package net.aihelp.core.util.concurrent;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;

public class HandlerThreadExecutor implements ApiExecutor {
    private final Object syncLock = new Object();
    private Handler uiHandler;
    private Handler handler;

    public HandlerThreadExecutor(String name) {
        HandlerThread handlerThread = new HandlerThread(name);
        handlerThread.start();
        this.handler = new Handler(handlerThread.getLooper());
        this.uiHandler = new Handler(Looper.getMainLooper());
    }

    public void runAsync(Runnable r) {
        this.handler.post(r);
    }

    @Override
    public void runAsyncDelayed(Runnable r, long delayMillis) {
        this.handler.postDelayed(r, delayMillis);
    }

    public void runSync(Runnable r) {
        NotifyingRunnable runnable = new NotifyingRunnable(r);
        synchronized(this.syncLock) {
            this.handler.post(runnable);
            runnable.waitForCompletion();
        }
    }

    public void runSyncDelayed(Runnable r, long delayMillis) {
        NotifyingRunnable runnable = new NotifyingRunnable(r);
        synchronized(this.syncLock) {
            this.handler.postDelayed(runnable, delayMillis);
            runnable.waitForCompletion();
        }
    }

    public void runOnUiThread(final Runnable r) {
        this.runAsync(new Runnable() {
            public void run() {
                HandlerThreadExecutor.this.uiHandler.post(r);
            }
        });
    }

    public void runOnUiThreadDelayed(final Runnable r, long delayMillis) {
        this.runAsync(new Runnable() {
            public void run() {
                HandlerThreadExecutor.this.uiHandler.postDelayed(r, delayMillis);
            }
        });
    }

    public void awaitForSyncExecution() {
        this.runSync(new Runnable() {
            public void run() {
            }
        });
    }
}
