package net.aihelp.core.util.crash.logger;

import android.content.Context;
import android.util.Log;

import net.aihelp.config.AIHelpContext;
import net.aihelp.utils.FileUtil;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.File;
import java.io.FileOutputStream;

public class LoggerController {

    private static final String TAG = LoggerController.class.getSimpleName();

    private JSONArray jsonArray = new JSONArray();

    public void saveCrashInfoFile(final int level, final String message, final String stacktrace, final long timeStamp) {
        try {

            JSONObject jsonObject = new JSONObject();
            jsonObject.put("level", getLogLevel(level));
            jsonObject.put("message", message);
            jsonObject.put("stacktrace", stacktrace);
            jsonObject.put("timeStamp", timeStamp);
            jsonArray.put(jsonObject);

            File crashFile = new File(getCrashFilePath(AIHelpContext.getInstance().getContext()));
            if (crashFile.exists()) crashFile.delete();
            FileOutputStream fos = new FileOutputStream(crashFile.getAbsoluteFile(), true);
            fos.write(jsonArray.toString().getBytes());
            fos.flush();
            fos.close();

        } catch (Exception e) {
            Log.e(TAG, "an error occured while writing file...", e);
        }
    }

    public static String getCrashFilePath(Context context) {
        String dirPath = "";
        File filesDir = context.getFilesDir();
        if (filesDir != null) {
            dirPath = filesDir.getAbsolutePath() + "/AIHelp/crash";
            File dirFile = new File(dirPath);
            if (!dirFile.exists()) {
                if (dirFile.mkdirs()) {
                    return dirFile.getAbsolutePath() + File.separator + "CrashLog.txt";
                }
            }
        }
        return dirPath + File.separator + "CrashLog.txt";
    }

    public JSONArray getCrashLog() {
        String content = FileUtil.getContentFromFile(getCrashFilePath(AIHelpContext.getInstance().getContext()));
        try {
            return new JSONArray(content);
        } catch (JSONException e) {
            return new JSONArray();
        }
    }

    public void reset() {
        jsonArray = new JSONArray();
    }

    private static final class LazyHolder {
        static final LoggerController INSTANCE = new LoggerController();
    }

    public static LoggerController getInstance() {
        return LoggerController.LazyHolder.INSTANCE;
    }

    private String getLogLevel(int level) {
        switch (level) {
            case AIHelpCrashLogger.LEVEL_FATAL:
                return "fatal";
            case AIHelpCrashLogger.LEVEL_ERROR:
                return "error";
            case AIHelpCrashLogger.LEVEL_WARN:
            default:
                return "warn";
        }
    }

}
