package net.aihelp.data.localize.config;

import android.text.TextUtils;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.LocalizeHelper;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.data.model.config.StyleSheetEntity;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.FileUtil;

public enum StyleSheetHelper {

    INSTANCE;

    public void prepareDataSource() {
        try {
            // 从本地读取样式配置文件
            String content = FileUtil.getContentFromFile(LocalizeUtil.getFileLocation(LocalizeHelper.MODE_TEMPLATE_STYLE_SHEET));
            if (!TextUtils.isEmpty(content)) {
                StyleSheetEntity styleEntity = JsonHelper.toJavaObject(content, StyleSheetEntity.class);
                if (styleEntity != null) {
                    prepareCommonConfig(styleEntity.getGeneral());
                    prepareHelpCenterConfig(styleEntity.getHelp());
                    prepareCustomerServiceConfig(styleEntity.getOnLine());
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void prepareCustomerServiceConfig(StyleSheetEntity.OnLineEntity entity) {
        CustomConfig.CustomerService.csNavigationBarTitleIcon = getAdjustedUrl(entity.getNavBar());
        CustomConfig.CustomerService.csBotSupportPortrait = getAdjustedUrl(entity.getRobotImgUrl());
        CustomConfig.CustomerService.csManualSupportPortrait = getAdjustedUrl(entity.getCustomerImgUrl());
        CustomConfig.CustomerService.csUserPortrait = getAdjustedUrl(entity.getUserImgUrl());
    }

    private void prepareHelpCenterConfig(StyleSheetEntity.HelpEntity entity) {
        CustomConfig.HelpCenter.faqNavigationBarTitleIcon = getAdjustedUrl(entity.getNavBar());
        CustomConfig.HelpCenter.faqNotificationIcon = getAdjustedUrl(entity.getNoticeBar());
        CustomConfig.HelpCenter.faqHotTopicTitleIcon = getAdjustedUrl(entity.getFaqList());
        CustomConfig.HelpCenter.faqSectionTitleIcon = getAdjustedUrl(entity.getFaqSectionList());
    }

    private void prepareCommonConfig(StyleSheetEntity.GeneralEntity entity) {

        if (entity.getNavBar() != null) {
            CustomConfig.CommonSetting.navigationBarBackground = entity.getNavBar().getColor();
            CustomConfig.CommonSetting.navigationBarAlpha = entity.getNavBar().getTransparency();
        }

        CustomConfig.CommonSetting.backgroundColorForAll = entity.getVertical();
        CustomConfig.CommonSetting.backgroundImageForPortrait = getAdjustedUrl(entity.getVerticalImgUrl());
        CustomConfig.CommonSetting.backgroundImageForLandscape = getAdjustedUrl(entity.getHorizontalImgUrl());

        if (entity.getFrontColor() != null) {
            CustomConfig.CommonSetting.upperBackgroundColor = entity.getFrontColor().getColor();
            CustomConfig.CommonSetting.upperBackgroundAlpha = entity.getFrontColor().getTransparency();
        }

        CustomConfig.CommonSetting.textColor = entity.getTextColor();
        CustomConfig.CommonSetting.highlightedColor = entity.getHighlightColor();
        CustomConfig.CommonSetting.interactElementTextColor = entity.getButtonColor();
        CustomConfig.CommonSetting.scaleFactor = (float) Math.min(Math.max(1.0f, entity.getFontSize()), 2.0f);
    }

    private String getAdjustedUrl(String originUrl) {
        return DomainSupportHelper.getAdjustedUrl(originUrl);
    }

}
