package net.aihelp.data.localize.data;

import android.text.TextUtils;

import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.LocalizeHelper;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.data.model.faq.FaqListEntity;
import net.aihelp.utils.FileUtil;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public enum RpaPredictionHelper {

    INSTANCE;

    private final ConcurrentHashMap<String, JSONArray> rpaMapping = new ConcurrentHashMap<>();

    public ConcurrentHashMap<String, JSONArray> getRpaMapping() {
        return rpaMapping;
    }

    public void reset() {
        rpaMapping.clear();
    }

    public void prepareDataSource() {
        try {
            // 从本地读取 FAQ 文件
            String content = FileUtil.getContentFromFile(LocalizeUtil.getFileLocation(LocalizeHelper.MODE_RPA_PREDICTION));
            if (!TextUtils.isEmpty(content)) {
                JSONArray jsonArray = new JSONArray(content);
                for (int i = 0; i < jsonArray.length(); i++) {
                    JSONObject jsonObject = JsonHelper.getJsonObject(jsonArray, i);
                    String question = JsonHelper.optString(jsonObject, "question");
                    JSONArray similarityQuestions = JsonHelper.getJsonArray(jsonObject, "similarityQuestion");
                    rpaMapping.put(question, similarityQuestions);
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

}
