package net.aihelp.data.localize.util;

import android.text.TextUtils;

import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.config.AIHelpContext;
import net.aihelp.data.localize.LocalizeHelper;
import net.aihelp.utils.TLog;

import java.io.File;

public class LocalizeUtil {

    public static boolean isFallbackUrl(int mode, String url) {
        return mode == LocalizeHelper.MODE_FAQ_SECTION && url.endsWith(String.format("%s-from-api.json", Const.CORRECT_LANGUAGE));
    }

    public static String getFileLocation(int mode, String fileName) {
        String dirPath = "";
        File filesDir = AIHelpContext.getInstance().getContext().getFilesDir();
        if (filesDir != null) {
            dirPath = filesDir.getAbsolutePath() + "/AIHelp" + LocalizeUtil.getFolderName(mode) + Const.CORRECT_LANGUAGE;
            File dirFile = new File(dirPath);
            if (!dirFile.exists()) {
                if (dirFile.mkdirs()) {
                    return dirFile.getAbsolutePath() + File.separator + fileName;
                }
            }
        }
        return dirPath + File.separator + fileName;
    }

    public static String getFileLocation(int mode) {
        return getFileLocation(mode, LocalizeUtil.getFileName(mode));
    }

    public static String getUrl(int mode) {
        switch (mode) {
            case LocalizeHelper.MODE_INIT_PROCESS:
                return API.CONFIG_INIT_PROCESS;
            case LocalizeHelper.MODE_INIT_TEXT:
                return API.CONFIG_INIT_TEXT;
            case LocalizeHelper.MODE_INIT_UPLOAD_LIMIT:
                return API.CONFIG_INIT_UPLOAD_LIMIT;
            case LocalizeHelper.MODE_INIT_LOCALE:
                return API.CONFIG_INIT_LOCALE_FILE;
            case LocalizeHelper.MODE_INIT_BUSINESS_LOGIC:
                return API.CONFIG_INIT_BUSINESS_LOGIC;

            case LocalizeHelper.MODE_TEMPLATE_STYLE_SHEET:
                return API.CONFIG_TEMPLATE_STYLE_SHEET;
            case LocalizeHelper.MODE_TEMPLATE_BUSINESS_LOGIC:
                return API.CONFIG_TEMPLATE_BUSINESS_LOGIC;
            case LocalizeHelper.MODE_TEMPLATE_FAQ_HOT_TOPIC:
                return API.CONFIG_TEMPLATE_FAQ_HOT_TOPIC;
            case LocalizeHelper.MODE_TEMPLATE_TEXT:
                return API.CONFIG_TEMPLATE_TEXT;

            case LocalizeHelper.MODE_RPA_PREDICTION:
                return API.CONFIG_RPA_PREDICTION;

            case LocalizeHelper.MODE_SAMPLING_FILE:
                return API.SAMPLING_FILTER;

            default:
                return API.CDN_URL + LocalizeUtil.getFolderName(mode) + Const.APP_ID + File.separator + LocalizeUtil.getFileName(mode);
        }
    }

    // 判断当前本地有没有初始化返回的那几个文件
    public static boolean isAlreadyLocalized(int mode) {
        try {
            String path = getFileLocation(mode);
            File file = new File(path);
            if (file.exists()) {
                return true;
            }
//            else {
//                File parentFile = file.getParentFile();
//                if (parentFile != null) {
//                    File[] files = parentFile.listFiles();
//                    if (files != null && files.length > 0) {
//                        for (File oldFile : files) {
//                            if (oldFile.delete()) {
//                                return false;
//                            }
//                        }
//                    }
//                }
//            }
        } catch (Exception e) {
            TLog.d("LocalizeHelper check localize status failed.");
        }
        return false;
    }

    public static String getFolderName(int mode) {
        String middle = "";
        switch (mode) {
            case LocalizeHelper.MODE_FAQ_SECTION:
                middle = "/FAQ/";
                break;
            case LocalizeHelper.MODE_RPA_PREDICTION:
                middle = "/rpa-prediction/";
                break;

            case LocalizeHelper.MODE_INIT_LOCALE:
                middle = "/init-locale/";
                break;
            case LocalizeHelper.MODE_INIT_PROCESS:
                middle = "/init-process/";
                break;
            case LocalizeHelper.MODE_INIT_TEXT:
                middle = "/init-text/";
                break;
            case LocalizeHelper.MODE_INIT_UPLOAD_LIMIT:
                middle = "/init-upload/";
                break;
            case LocalizeHelper.MODE_INIT_BUSINESS_LOGIC:
                middle = "/init-toggle/";
                break;

            case LocalizeHelper.MODE_TEMPLATE_STYLE_SHEET:
                middle = "/template-style/";
                break;
            case LocalizeHelper.MODE_TEMPLATE_BUSINESS_LOGIC:
                middle = "/template-toggle/";
                break;
            case LocalizeHelper.MODE_TEMPLATE_FAQ_HOT_TOPIC:
                middle = "/template-hotTopic/";
                break;
            case LocalizeHelper.MODE_TEMPLATE_TEXT:
                middle = "/template-text/";
                break;

            case LocalizeHelper.MODE_SAMPLING_FILE:
                middle = "/sampling/";
                break;
        }
        return middle;
    }

    public static String getFileName(int mode) {
        String fileName = "";
        switch (mode) {
            case LocalizeHelper.MODE_FAQ_SECTION:
                fileName = getLocalizeFileName(Const.FAQ_FILE);
                break;
            case LocalizeHelper.MODE_RPA_PREDICTION:
                fileName = getLocalizeFileName(API.CONFIG_RPA_PREDICTION);
                break;

            case LocalizeHelper.MODE_INIT_LOCALE:
                fileName = getLocalizeFileName(API.CONFIG_INIT_LOCALE_FILE);
                break;
            case LocalizeHelper.MODE_INIT_PROCESS:
                fileName = getLocalizeFileName(API.CONFIG_INIT_PROCESS);
                break;
            case LocalizeHelper.MODE_INIT_TEXT:
                fileName = getLocalizeFileName(API.CONFIG_INIT_TEXT);
                break;
            case LocalizeHelper.MODE_INIT_UPLOAD_LIMIT:
                fileName = getLocalizeFileName(API.CONFIG_INIT_UPLOAD_LIMIT);
                break;
            case LocalizeHelper.MODE_INIT_BUSINESS_LOGIC:
                fileName = getLocalizeFileName(API.CONFIG_INIT_BUSINESS_LOGIC);
                break;

            case LocalizeHelper.MODE_TEMPLATE_STYLE_SHEET:
                fileName = getLocalizeFileName(API.CONFIG_TEMPLATE_STYLE_SHEET);
                break;
            case LocalizeHelper.MODE_TEMPLATE_BUSINESS_LOGIC:
                fileName = getLocalizeFileName(API.CONFIG_TEMPLATE_BUSINESS_LOGIC);
                break;
            case LocalizeHelper.MODE_TEMPLATE_FAQ_HOT_TOPIC:
                fileName = getLocalizeFileName(API.CONFIG_TEMPLATE_FAQ_HOT_TOPIC);
                break;
            case LocalizeHelper.MODE_TEMPLATE_TEXT:
                fileName = getLocalizeFileName(API.CONFIG_TEMPLATE_TEXT);
                break;

            case LocalizeHelper.MODE_SAMPLING_FILE:
                fileName = getLocalizeFileName(API.SAMPLING_FILTER);
                break;
        }
        return fileName;
    }

    private static String getLocalizeFileName(String url) {
        if (!TextUtils.isEmpty(url)) {
            String[] split = url.split("/");
            if (split.length > 0) {
                return split[split.length - 1];
            }
        }
        return String.format("%s-from-api.json", Const.CORRECT_LANGUAGE);
    }

}
