package net.aihelp.data.logic.cs;

import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.utils.ListUtil;

import java.util.List;


public class TicketStatusTracker {

    public static int TICKET_ASSIGNED_TO_AGENT = 1;
    public static int TICKET_ASSIGNED_TO_RPA_BOT = 2;
    public static int TICKET_UNASSIGNED_WITH_AGENT = 11;
    public static int TICKET_UNASSIGNED_WITH_BOT = 12;

    public static int TICKET_STATUS_FINISHED = 6;
    public static int TICKET_STATUS_REJECTED = 9;

    public static String currentTicketId;
    public static int ticketPollInterval = 60;

    public static long firstMessageTimeStampInList;

    public static boolean isTicketActive;   // 当前是否有进行中客诉
    public static boolean isTicketFinished; // 当前客诉是否已完成
    public static boolean isTicketRejected; // 当前客诉是否被回绝

    public static boolean hasUnreadMsg; // 是否有未读消息

    public static int ticketAssignType;

    public static boolean isTicketServingByNobody() {
        return ticketAssignType == TICKET_UNASSIGNED_WITH_AGENT;
    }

    public static boolean isTicketServingByAgent() {
        return ticketAssignType == TICKET_ASSIGNED_TO_AGENT || ticketAssignType == TICKET_UNASSIGNED_WITH_AGENT;
    }

    public static boolean isTicketServingByRPA() {
        return ticketAssignType == TICKET_ASSIGNED_TO_RPA_BOT;
    }

    public static boolean isTicketServingByAnswerBot() {
        return ticketAssignType == TICKET_UNASSIGNED_WITH_BOT;
    }

    public static void setFirstMessageTimeStampInList(List<Message> msgList) {
        if (!ListUtil.isListEmpty(msgList)) {
            Message message = msgList.get(0);
            if (message != null) {
                TicketStatusTracker.firstMessageTimeStampInList = message.getTimestamp();
            }
        }
    }

    public static void updateAssignTypeWithActiveStatus(boolean isTicketActive, int ticketAssignType) {
        TicketStatusTracker.isTicketActive = isTicketActive;
        TicketStatusTracker.hasUnreadMsg = false; // 重新登录之后重置未读消息数
        TicketStatusTracker.ticketAssignType = ticketAssignType;
        if (!isTicketActive) {
            TicketStatusTracker.ticketAssignType = TICKET_UNASSIGNED_WITH_BOT;
        }
    }

    public static void resetTicketStatusFlags() {
        hasUnreadMsg = false;
        isTicketActive = false;
        isTicketFinished = false;
        isTicketRejected = false;
    }

}
