package net.aihelp.data.logic.cs.predict;

import android.text.TextUtils;

import net.aihelp.data.logic.cs.predict.matching.FaqKeywordsMatching;
import net.aihelp.data.logic.cs.predict.matching.FaqSimilarityMatching;
import net.aihelp.data.logic.cs.predict.matching.FaqTitleMatching;
import net.aihelp.data.logic.cs.predict.matching.RpaSimilarityMatching;
import net.aihelp.data.logic.cs.predict.matching.RpaTitleMatching;
import net.aihelp.data.model.faq.FaqListEntity;
import net.aihelp.data.track.event.EventTracker;
import net.aihelp.data.track.event.utils.EventType;
import net.aihelp.data.track.statistic.StatisticTracker;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class PredictHelper {

    public static List<FaqListEntity> getPredictList(String query) {
        if (TextUtils.isEmpty(query) || query.length() > 200) {
            return new ArrayList<>();
        }

        List<FaqListEntity> matchedList = new ArrayList<>();

        FaqTitleMatching faqTitleMatching = new FaqTitleMatching();
        faqTitleMatching
                .chainTo(new FaqKeywordsMatching())
                .chainTo(new FaqSimilarityMatching())
                .chainTo(new RpaTitleMatching())
                .chainTo(new RpaSimilarityMatching());

        return faqTitleMatching.processMatch(matchedList, query);
    }

}
