package net.aihelp.data.logic.cs.predict.matching;

import android.text.TextUtils;

import net.aihelp.data.model.faq.FaqListEntity;

import java.util.List;

public abstract class BaseMatching {

    public static final int MAX_COUNT = 6;

    protected BaseMatching next;

    public BaseMatching chainTo(BaseMatching next) {
        this.next = next;
        return next;
    }

    public abstract List<FaqListEntity> processMatch(List<FaqListEntity> matchedList, String query);

    public List<FaqListEntity> getMatchingResult(List<FaqListEntity> matchedList, String query) {
        if (next == null || matchedList.size() >= MAX_COUNT) {
            return matchedList;
        }
        return next.processMatch(matchedList, query);
    }

    public void addWithoutDuplication(List<FaqListEntity> matchedList, FaqListEntity faqEntity) {
        if (matchedList.size() < MAX_COUNT) {
            boolean isDuplicate = false;
            for (FaqListEntity existFaq : matchedList) {
                if (existFaq != null && faqEntity != null &&
                        TextUtils.equals(existFaq.getId(), faqEntity.getId())) {
                    isDuplicate = true;
                    break;
                }
            }
            if (!isDuplicate) {
                matchedList.add(faqEntity);
            }
        }
    }

}
