package net.aihelp.data.logic.cs.predict.matching;

import android.text.TextUtils;

import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.data.FaqHelper;
import net.aihelp.data.model.faq.FaqListEntity;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class FaqKeywordsMatching extends BaseMatching {

    @Override
    public List<FaqListEntity> processMatch(List<FaqListEntity> matchedList, String query) {

        JSONArray sourceFaqs = FaqHelper.INSTANCE.getRawFlatFaqArray();
        List<FaqListEntity> unorderedList = new ArrayList<>();

        outer:
        for (int i = 0; i < sourceFaqs.length(); i++) {
            JSONObject faq = JsonHelper.getJsonObject(sourceFaqs, i);
            if (faq.optBoolean("isHidden")) {
                continue;
            }
            String keywords = faq.optString("keyWords");
            if (!TextUtils.isEmpty(keywords)) {
                String[] keywordsArr = keywords.split(",");
                for (String keyword : keywordsArr) {
                    if (query.toLowerCase().contains(keyword.toLowerCase())) {
                        if (matchedEnough(unorderedList, faq, query)) {
                            break outer;
                        }
                    }
                }
            }
        }

        Collections.sort(unorderedList, new Comparator<FaqListEntity>() {
            @Override
            public int compare(FaqListEntity o1, FaqListEntity o2) {
                return o2.getOrder() - o1.getOrder();
            }
        });

        for (FaqListEntity faqListEntity : unorderedList) {
            addWithoutDuplication(matchedList, faqListEntity);
        }

        return getMatchingResult(matchedList, query);
    }

    private boolean matchedEnough(List<FaqListEntity> unorderedList, JSONObject faq, String query) {
        String faqMainId = faq.optString("kmMainid");
        String faqTitle = faq.optString("question");
        boolean isInserted = false;
        for (int j = 0; j < unorderedList.size(); j++) {
            FaqListEntity unorderedFaq = unorderedList.get(j);
            if (TextUtils.equals(unorderedFaq.getId(), faqMainId)) {
                unorderedFaq.setOrder(unorderedFaq.getOrder() + 1);
                isInserted = true;
                break;
            }
        }
        if (!isInserted) {
            FaqListEntity faqEntity = FaqListEntity.createPrediction(faqMainId, faqTitle, query);
            faqEntity.setOrder(1);
            unorderedList.add(faqEntity);
        }
        return unorderedList.size() == MAX_COUNT;
    }

}
