package net.aihelp.data.logic.cs.predict.matching;

import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.data.FaqHelper;
import net.aihelp.data.model.faq.FaqListEntity;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.List;

public class FaqSimilarityMatching extends BaseMatching {

    @Override
    public List<FaqListEntity> processMatch(List<FaqListEntity> matchedList, String query) {
        JSONArray sourceFaqs = FaqHelper.INSTANCE.getRawFlatFaqArray();
        for (int i = 0; i < sourceFaqs.length(); i++) {
            JSONObject faq = JsonHelper.getJsonObject(sourceFaqs, i);
            if (faq.optBoolean("isHidden")) {
                continue;
            }
            String faqMainId = faq.optString("kmMainid");
            String faqTitle = faq.optString("question");
            String similarQuestions = faq.optString("similarQuestions");
            if (similarQuestions.toLowerCase().contains(query.toLowerCase())) {
                addWithoutDuplication(matchedList, FaqListEntity.createPrediction(faqMainId, faqTitle, query));
            }
        }
        return getMatchingResult(matchedList, query);
    }

}
