package net.aihelp.data.logic.cs.predict.matching;

import net.aihelp.data.localize.data.RpaPredictionHelper;
import net.aihelp.data.model.faq.FaqListEntity;

import org.json.JSONArray;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class RpaSimilarityMatching extends BaseMatching {

    @Override
    public List<FaqListEntity> processMatch(List<FaqListEntity> matchedList, String query) {
        ConcurrentHashMap<String, JSONArray> rpaMapping = RpaPredictionHelper.INSTANCE.getRpaMapping();
        for (String rpaQuestion : rpaMapping.keySet()) {
            JSONArray similarQuestions = rpaMapping.get(rpaQuestion);
            if (similarQuestions != null) {
                for (int i = 0; i < similarQuestions.length(); i++) {
                    String similarQuestion = similarQuestions.optString(i);
                    if (similarQuestion.toLowerCase().contains(query.toLowerCase())) {
                        addWithoutDuplication(matchedList, FaqListEntity.createPrediction(rpaQuestion, rpaQuestion, query));
                    }
                }
            }
        }
        return getMatchingResult(matchedList, query);
    }

}
