package net.aihelp.data.logic.cs.predict.matching;

import net.aihelp.data.localize.data.RpaPredictionHelper;
import net.aihelp.data.model.faq.FaqListEntity;

import org.json.JSONArray;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class RpaTitleMatching extends BaseMatching {

    @Override
    public List<FaqListEntity> processMatch(List<FaqListEntity> matchedList, String query) {
        ConcurrentHashMap<String, JSONArray> rpaMapping = RpaPredictionHelper.INSTANCE.getRpaMapping();
        for (String rpaQuestion : rpaMapping.keySet()) {
            if (rpaQuestion.toLowerCase().contains(query.toLowerCase())) {
                addWithoutDuplication(matchedList, FaqListEntity.createPrediction(rpaQuestion, rpaQuestion, query));
            }
        }
        return getMatchingResult(matchedList, query);
    }

}
