package net.aihelp.data.model.config;

import net.aihelp.data.model.init.PrivacyControlEntity;

public class BusinessLogicEntity {

    private GeneralEntity general;
    private HelpEntity help;
    private OnLineEntity onLine;

    public GeneralEntity getGeneral() {
        return general;
    }

    public void setGeneral(GeneralEntity general) {
        this.general = general;
    }

    public HelpEntity getHelp() {
        return help;
    }

    public void setHelp(HelpEntity help) {
        this.help = help;
    }

    public OnLineEntity getOnLine() {
        return onLine;
    }

    public void setOnLine(OnLineEntity onLine) {
        this.onLine = onLine;
    }

    public static class GeneralEntity {

        public static final int BG_OPTION_COLOR = 1;
        public static final int BG_OPTION_IMAGE = 2;

        private int bgOptions;
        private FaqEvaluationEntity faqEvaluation;
        private int direction;
        private PrivacyControlEntity information;

        public int getBgOptions() {
            return bgOptions;
        }

        public void setBgOptions(int bgOptions) {
            this.bgOptions = bgOptions;
        }

        public FaqEvaluationEntity getFaqEvaluation() {
            return faqEvaluation;
        }

        public void setFaqEvaluation(FaqEvaluationEntity faqEvaluation) {
            this.faqEvaluation = faqEvaluation;
        }

        public int getDirection() {
            return direction;
        }

        public void setDirection(int direction) {
            this.direction = direction;
        }

        public PrivacyControlEntity getInformation() {
            return information;
        }

        public void setInformation(PrivacyControlEntity information) {
            this.information = information;
        }

        public static class FaqEvaluationEntity {
            private boolean isOnlineValid;
            private boolean isFaqDetailValid;
            private boolean isSuggestionValid;
            private boolean isOperateDetailValid;

            public boolean isOnlineValid() {
                return isOnlineValid;
            }

            public void setOnlineValid(boolean onlineValid) {
                isOnlineValid = onlineValid;
            }

            public boolean isFaqDetailValid() {
                return isFaqDetailValid;
            }

            public void setFaqDetailValid(boolean faqDetailValid) {
                isFaqDetailValid = faqDetailValid;
            }

            public boolean isSuggestionValid() {
                return isSuggestionValid;
            }

            public void setSuggestionValid(boolean suggestionValid) {
                isSuggestionValid = suggestionValid;
            }

            public boolean isOperateDetailValid() {
                return isOperateDetailValid;
            }

            public void setOperateDetailValid(boolean operateDetailValid) {
                isOperateDetailValid = operateDetailValid;
            }
        }

    }

    public static class HelpEntity {

        public static final int ARRANGEMENT_LIST = 1;
        public static final int ARRANGEMENT_GRID = 2;

        private boolean isTitleIconValid;
        private boolean isSearchValid;
        private NoticeBarEntity noticeBar;
        private FaqListEntity faqList;
        private FaqSectionListEntity faqSectionList;

        public boolean getIsTitleIconValid() {
            return isTitleIconValid;
        }

        public void setIsTitleIconValid(boolean isTitleIconValid) {
            this.isTitleIconValid = isTitleIconValid;
        }

        public boolean getIsSearchValid() {
            return isSearchValid;
        }

        public void setIsSearchValid(boolean isSearchValid) {
            this.isSearchValid = isSearchValid;
        }

        public NoticeBarEntity getNoticeBar() {
            return noticeBar;
        }

        public void setNoticeBar(NoticeBarEntity noticeBar) {
            this.noticeBar = noticeBar;
        }

        public FaqListEntity getFaqList() {
            return faqList;
        }

        public void setFaqList(FaqListEntity faqList) {
            this.faqList = faqList;
        }

        public FaqSectionListEntity getFaqSectionList() {
            return faqSectionList;
        }

        public void setFaqSectionList(FaqSectionListEntity faqSectionList) {
            this.faqSectionList = faqSectionList;
        }

        public static class NoticeBarEntity {
            private boolean isNoticeValid;
            private boolean isNoticeIconValid;
            private int intervals;

            public boolean getIsNoticeValid() {
                return isNoticeValid;
            }

            public void setIsNoticeValid(boolean isNoticeValid) {
                this.isNoticeValid = isNoticeValid;
            }

            public boolean getIsNoticeIconValid() {
                return isNoticeIconValid;
            }

            public void setIsNoticeIconValid(boolean isNoticeIconValid) {
                this.isNoticeIconValid = isNoticeIconValid;
            }

            public int getIntervals() {
                return intervals;
            }

            public void setIntervals(int intervals) {
                this.intervals = intervals;
            }
        }

        public static class FaqListEntity {
            private boolean isFaqListValid;
            private boolean isTitleIconValid;
            private boolean isTitleValid;
            private boolean isFaqIconValid;

            public boolean getIsFaqListValid() {
                return isFaqListValid;
            }

            public void setIsFaqListValid(boolean isFaqListValid) {
                this.isFaqListValid = isFaqListValid;
            }

            public boolean getIsTitleIconValid() {
                return isTitleIconValid;
            }

            public void setIsTitleIconValid(boolean isTitleIconValid) {
                this.isTitleIconValid = isTitleIconValid;
            }

            public boolean getIsTitleValid() {
                return isTitleValid;
            }

            public void setIsTitleValid(boolean isTitleValid) {
                this.isTitleValid = isTitleValid;
            }

            public boolean getIsFaqIconValid() {
                return isFaqIconValid;
            }

            public void setIsFaqIconValid(boolean isFaqIconValid) {
                this.isFaqIconValid = isFaqIconValid;
            }
        }

        public static class FaqSectionListEntity {

            private boolean isTitleValid;
            private boolean isTitleIconValid;
            private boolean isFaqIconValid;
            private int arrangement;

            public boolean getIsTitleValid() {
                return isTitleValid;
            }

            public void setIsTitleValid(boolean isTitleValid) {
                this.isTitleValid = isTitleValid;
            }

            public boolean getIsTitleIconValid() {
                return isTitleIconValid;
            }

            public void setIsTitleIconValid(boolean isTitleIconValid) {
                this.isTitleIconValid = isTitleIconValid;
            }

            public boolean getIsFaqIconValid() {
                return isFaqIconValid;
            }

            public void setIsFaqIconValid(boolean isFaqIconValid) {
                this.isFaqIconValid = isFaqIconValid;
            }

            public int getArrangement() {
                return arrangement;
            }

            public void setArrangement(int arrangement) {
                this.arrangement = arrangement;
            }
        }
    }

    public static class OnLineEntity {
        private boolean isNavBarTitleIconValid;
        private boolean isHeadValid;
        private boolean isExternalName;
        private boolean isSendTime;
        private HistoryTicketEntity historyTicket;
        private SatisfiedEntity satisfied;
        private OperateModuleEntity operateModule;

        public boolean getIsNavBarTitleIconValid() {
            return isNavBarTitleIconValid;
        }

        public void setIsNavBarTitleIconValid(boolean isNavBarTitleIconValid) {
            this.isNavBarTitleIconValid = isNavBarTitleIconValid;
        }

        public boolean getIsHeadValid() {
            return isHeadValid;
        }

        public void setIsHeadValid(boolean isHeadValid) {
            this.isHeadValid = isHeadValid;
        }

        public boolean getIsExternalName() {
            return isExternalName;
        }

        public void setIsExternalName(boolean isExternalName) {
            this.isExternalName = isExternalName;
        }

        public boolean getIsSendTime() {
            return isSendTime;
        }

        public void setIsSendTime(boolean isSendTime) {
            this.isSendTime = isSendTime;
        }

        public HistoryTicketEntity getHistoryTicket() {
            return historyTicket;
        }

        public void setHistoryTicket(HistoryTicketEntity historyTicket) {
            this.historyTicket = historyTicket;
        }

        public SatisfiedEntity getSatisfied() {
            return satisfied;
        }

        public void setSatisfied(SatisfiedEntity satisfied) {
            this.satisfied = satisfied;
        }

        public OperateModuleEntity getOperateModule() {
            return operateModule;
        }

        public void setOperateModule(OperateModuleEntity operateModule) {
            this.operateModule = operateModule;
        }

        public static class HistoryTicketEntity {
            private boolean isValid;

            public boolean getIsValid() {
                return isValid;
            }

            public void setIsValid(boolean isValid) {
                this.isValid = isValid;
            }
        }

        public static class SatisfiedEntity {
            private boolean isValid;
            private boolean isFeedback;
            private int feedbackMax;

            public boolean isValid() {
                return isValid;
            }

            public void setValid(boolean valid) {
                isValid = valid;
            }

            public boolean isFeedback() {
                return isFeedback;
            }

            public void setFeedback(boolean feedback) {
                isFeedback = feedback;
            }

            public void setIsFeedback(boolean isFeedback) {
                this.isFeedback = isFeedback;
            }

            public int getFeedbackMax() {
                return feedbackMax;
            }

            public void setFeedbackMax(int feedbackMax) {
                this.feedbackMax = feedbackMax;
            }
        }

        public static class OperateModuleEntity {
            private boolean isOperateModule;
            private boolean isEvaluation;
            private int showOperateModule;

            public boolean getIsOperateModule() {
                return isOperateModule;
            }

            public void setIsOperateModule(boolean isOperateModule) {
                this.isOperateModule = isOperateModule;
            }

            public boolean getIsEvaluation() {
                return isEvaluation;
            }

            public void setIsEvaluation(boolean isEvaluation) {
                this.isEvaluation = isEvaluation;
            }

            public int getShowOperateModule() {
                return showOperateModule;
            }

            public void setShowOperateModule(int showOperateModule) {
                this.showOperateModule = showOperateModule;
            }
        }
    }
}
