package net.aihelp.data.model.config;

import android.text.TextUtils;

import org.json.JSONArray;

import java.util.ArrayList;
import java.util.List;

public class ProcessEntity {

    private int intent;
    private String visitId;
    private String faqId;
    private String sectionId;
    private String faqEntrances;
    private String tags;

    private boolean enableInteraction;
    private String smartIntentName;
    private List<IntentEntity> smartIntentList = new ArrayList<>();

    private String templateId;
    private String csEntrance;

    // for track
    private String entranceId;
    private String trackActiveId;

    public String getTemplateId() {
        if (TextUtils.isEmpty(templateId)) {
            return "";
        }
        return templateId;
    }

    public void setTemplateId(int templateId) {
        this.templateId = templateId + "";
    }

    public String getCsEntrance() {
        return csEntrance;
    }

    public void setCsEntrance(String csEntrance) {
        this.csEntrance = csEntrance;
    }

    public String getTrackActiveId() {
        return trackActiveId;
    }

    public void setTrackActiveId(String trackActiveId) {
        this.trackActiveId = trackActiveId;
    }

    public int getIntent() {
        return intent;
    }

    public void setIntent(int intent) {
        this.intent = intent;
    }

    public String getVisitId() {
        return visitId;
    }

    public void setVisitId(String visitId) {
        this.visitId = visitId;
    }

    public String getFaqId() {
        return faqId;
    }

    public void setFaqId(String faqId) {
        this.faqId = faqId;
    }

    public String getSectionId() {
        return sectionId;
    }

    public void setSectionId(String sectionId) {
        this.sectionId = sectionId;
    }

    public String getTags() {
        return tags;
    }

    public void setTags(JSONArray array) {
        this.tags = getStringFromJsonArray(array);
    }

    public String getFaqEntrances() {
        return faqEntrances;
    }

    public void setFaqEntrances(JSONArray array) {
        this.faqEntrances = getStringFromJsonArray(array);
    }

    public boolean isEnableInteraction() {
        return enableInteraction;
    }

    public void setEnableInteraction(boolean enableInteraction) {
        this.enableInteraction = enableInteraction;
    }

    public String getSmartIntentName() {
        return smartIntentName;
    }

    public void setSmartIntentName(String smartIntentName) {
        this.smartIntentName = smartIntentName;
    }

    public List<IntentEntity> getSmartIntentList() {
        return smartIntentList;
    }

    public void setSmartIntentList(List<IntentEntity> smartIntentList) {
        this.smartIntentList = smartIntentList;
    }

    private String getStringFromJsonArray(JSONArray array) {
        StringBuilder stringBuilder = new StringBuilder();
        if (array != null) {
            for (int i = 0; i < array.length(); i++) {
                stringBuilder.append(array.optString(i));
                if (i != array.length() - 1) {
                    stringBuilder.append(",");
                }
            }
        }
        return stringBuilder.toString();
    }

    public String getEntranceId() {
        return entranceId;
    }

    public void setEntranceId(String entranceId) {
        this.entranceId = entranceId;
    }

}
