package net.aihelp.data.model.rpa.msg;

import android.webkit.MimeTypeMap;

import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.utils.RegexUtil;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UserMessage extends Message {

    public static final int INPUT_FORMAT_TEXT = 1;
    public static final int INPUT_FORMAT_BUTTON = 2;
    public static final int INPUT_FORMAT_DATE = 3;
    public static final int INPUT_FORMAT_ATTACHMENT = 4;
    public static final int INPUT_FORMAT_INTENT = 5;

    public static final int INPUT_SOURCE_INPUT = 1;
    public static final int INPUT_SOURCE_ACTION = 2;
    public static final int INPUT_SOURCE_DATE = 3;
    public static final int INPUT_SOURCE_SELF_SERVICE = 4;
    public static final int INPUT_SOURCE_RPA_FAQ = 5;
    public static final int INPUT_SOURCE_ANSWER_BOT = 6;
    public static final int INPUT_SOURCE_SKIP = 7;
    public static final int INPUT_SOURCE_INTENT = 8;
    public static final int INPUT_SOURCE_PREDICT = 9;

    private int evaluateGrade;

    public int getEvaluateGrade() {
        return evaluateGrade;
    }

    public void setEvaluateGrade(int evaluateGrade) {
        this.evaluateGrade = evaluateGrade;
    }

    /**
     * 当收到客服消息时，这个数据有可能是图片、视频、富文本等，还需要特殊判断和处理
     */
    public void setContent(String content) {
        Matcher imageMatcher = Pattern.compile(RegexUtil.REGEX_IMAGE).matcher(content);
        Matcher videoMatcher = Pattern.compile(RegexUtil.REGEX_VIDEO).matcher(content);
        if (!imageMatcher.matches() && !videoMatcher.matches()) {
            // 复制 msg 内容，用来获取表单的文字内容
            String textMsg = content;
            // 移除所有图片链接
            while (imageMatcher.find()) {
                textMsg = textMsg.replace(imageMatcher.group(), "");
            }
            // 使用移除图片链接后的字符串重新校验视频链接，否则会匹配中 imageUrl+videoUrl
            Matcher newVideoMatcher = Pattern.compile(RegexUtil.REGEX_VIDEO).matcher(textMsg);
            while (newVideoMatcher.find()) {
                textMsg = textMsg.replace(newVideoMatcher.group(), "");
            }
            super.setContent(textMsg.replace(";", ""));
            setMsgType(Message.TYPE_USER_TEXT);
        }
        setMsgStatus(STATUS_NORMAL);
    }

    public void setRequestParams(String input, int inputFormat, int inputSource) {
        super.setRequestParams(getRequestParams(input, inputFormat, inputSource));
    }

    public void setRequestParams(String input, boolean skip, int inputFormat, String inputData, int inputSource) {
        super.setRequestParams(getRequestParams(input, skip, inputFormat, inputData, inputSource));
    }

    // region - 获取发送消息的时候需要的参数
    public static JSONObject getRequestParams(String input, int inputFormat, int inputSource) {
        return getRequestParams(input, false, inputFormat, "", inputSource);
    }

    public static JSONObject getRequestParams(String input, boolean skip,
                                              int inputFormat, String inputData, int inputSource) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("input", input);
            jsonObject.put("skip", skip);
            jsonObject.put("inputFormat", inputFormat);
            jsonObject.put("inputData", inputData);
            jsonObject.put("inputSource", inputSource);
            jsonObject.put("eventId", UUID.randomUUID().toString().replace("-", ""));
            return jsonObject;
        } catch (Exception e) {
            return new JSONObject();
        }
    }

    public static JSONObject getRequestParams(String url, String fileName, long fileSize, float width, float height) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("input", "");
            jsonObject.put("skip", false);
            jsonObject.put("inputFormat", INPUT_FORMAT_ATTACHMENT);
            jsonObject.put("inputData", "");
            jsonObject.put("eventId", UUID.randomUUID().toString().replace("-", ""));

            JSONArray attachmentList = new JSONArray();
            JSONObject attachmentItem = new JSONObject();
            attachmentItem.put("url", url);
            attachmentItem.put("filename", fileName);
            attachmentItem.put("size", fileSize);
            attachmentItem.put("width", width);
            attachmentItem.put("height", height);
            attachmentItem.put("type", MimeTypeMap.getFileExtensionFromUrl(url));
            attachmentList.put(attachmentItem);
            jsonObject.put("attachments", attachmentList);
            return jsonObject;
        } catch (Exception e) {
            return new JSONObject();
        }
    }

    // endregion


}
