package net.aihelp.data.model.rpa.msg.base;

import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.helper.BitmapHelper;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.MediaUtils;

import java.text.DecimalFormat;

public class FileMessage extends Message {

    private String videoThumbnail;
    private int[] imageSize;
    private String fileName;
    private long fileSize;

    public FileMessage(int msgType) {
        this(msgType, "");
    }

    public FileMessage(int msgType, String content) {
        super(msgType);
        setContent(content);
    }

    public String getFileName() {
        return fileName;
    }

    public void setFileInfo(String fileName, long fileSize) {
        this.fileName = fileName;
        this.fileSize = fileSize;
    }

    public String getFileSize() {
        DecimalFormat df = new DecimalFormat("#.00");
        String fileSizeString;
        String wrongSize = "0B";
        if (fileSize == 0) {
            return wrongSize;
        }
        if (fileSize < 1024) {
            fileSizeString = fileSize + "B";
        } else if (fileSize < 1048576) {
            fileSizeString = df.format((double) fileSize / 1024) + "KB";
        } else if (fileSize < 1073741824) {
            fileSizeString = df.format((double) fileSize / 1048576) + "MB";
        } else {
            fileSizeString = df.format((double) fileSize / 1073741824) + "GB";
        }
        return fileSizeString;
    }

    public String getVideoThumbnail() {
        return videoThumbnail;
    }

    public void setVideoThumbnail(String videoThumbnail) {
        this.videoThumbnail = videoThumbnail;
        setImageSize(BitmapHelper.computeSize(videoThumbnail));
    }

    public int[] getImageSize() {
        return imageSize;
    }

    public void setImageSize(int[] imageSize) {
        this.imageSize = imageSize;
    }

    public void prepareVideoThumbnail() {
        String correctContent = DomainSupportHelper.getAdjustedUrl(getContent());
        String videoThumbnail = MediaUtils.getImageForVideoSync(correctContent);
        setVideoThumbnail(videoThumbnail);
    }

}
