package net.aihelp.data.model.rpa.msg.base;

import android.text.TextUtils;

import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.model.rpa.msg.BotMessage;
import net.aihelp.data.model.rpa.msg.UserMessage;

import org.json.JSONObject;

public class Message {

    public static final int TYPE_TIMESTAMP = 1;
    public static final int TYPE_LOADING = 2;

    public static final int TYPE_AGENT_TEXT = 3;
    public static final int TYPE_AGENT_RPA_FAQ = 4;
    public static final int TYPE_AGENT_BOT_ANSWER = 5;
    public static final int TYPE_AGENT_IMAGE = 6;
    public static final int TYPE_AGENT_VIDEO = 7;
    public static final int TYPE_AGENT_RICH_TEXT = 8;
    public static final int TYPE_AGENT_FILE = 9;

    public static final int TYPE_USER_TEXT = 10;
    public static final int TYPE_USER_IMAGE = 11;
    public static final int TYPE_USER_VIDEO = 12;
    public static final int TYPE_USER_EVALUATE_FAQ = 13;
    public static final int TYPE_USER_FILE = 14;
    public static final int TYPE_USER_EVALUATE_SERVICE = 15;

    public static final int STATUS_NORMAL = 1;
    public static final int STATUS_SENDING = 2;
    public static final int STATUS_FAILURE = 3;

    public static final int REQUEST_TYPE_RPA = 1;
    public static final int REQUEST_TYPE_RESOLUTION = 2;
    public static final int REQUEST_TYPE_EVALUATE = 3;

    public Message() {
        setMsgStatus(STATUS_NORMAL);
        setTimestamp(System.currentTimeMillis());
    }

    public Message(int msgType) {
        this();
        this.msgType = msgType;
    }

    // 这个参数名称待定，其实想表达的只是是否需要添加到列表
    // 取名 normal 是因为 1001 的状态定义是 normal，可以改一下，更清楚一些
    private boolean isNormalMessage;
    private boolean isDuringRPAProcedure = true;
    private JSONObject requestParams;
    private boolean enableInteraction = true;

    protected long timestamp;
    protected int msgType;
    protected int msgStatus = STATUS_NORMAL;
    protected String content;
    protected String nickname;

    private int requestType = REQUEST_TYPE_RPA;

    public int getRequestType() {
        return requestType;
    }

    public void setRequestType(int requestType) {
        this.requestType = requestType;
    }

    public boolean isEnableInteraction() {
        return enableInteraction;
    }

    public void setEnableInteraction(boolean enableInteraction) {
        this.enableInteraction = enableInteraction;
    }

    public boolean isNormalMessage() {
        return isNormalMessage;
    }

    public void setNormalMessage(boolean normalMessage) {
        this.isNormalMessage = normalMessage;
    }

    public boolean isDuringRPAProcedure() {
        return isDuringRPAProcedure;
    }

    public void setDuringRPAProcedure(boolean duringRPAProcedure) {
        isDuringRPAProcedure = duringRPAProcedure;
    }

    public JSONObject getRequestParams() {
        return requestParams;
    }

    public void setRequestParams(JSONObject requestParams) {
        this.requestParams = requestParams;
    }

    public long getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(long timestamp) {
        if (timestamp > 0) {
            this.timestamp = timestamp;
        }
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public int getMsgType() {
        return msgType;
    }

    public void setMsgType(int msgType) {
        this.msgType = msgType;
    }

    public int getMsgStatus() {
        return msgStatus;
    }

    public void setMsgStatus(int msgStatus) {
        this.msgStatus = msgStatus;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public static Message getDefaultMessage() {
        BotMessage message = new BotMessage("");
        message.setTimestamp(100);
        String msg = "What can I do for you?";
        if (!TextUtils.isEmpty(Const.CUSTOM_WELCOME_MSG)) {
            msg = Const.CUSTOM_WELCOME_MSG;
        } else if (!TextUtils.isEmpty(CustomConfig.CustomerService.csWelcomeMessage)) {
            msg = CustomConfig.CustomerService.csWelcomeMessage;
        }
        message.setContent(msg);
        return message;
    }

    public static Message getAgentTypingMsg() {
        return new Message(TYPE_LOADING);
    }

    public static UserMessage getUserTextMsg(String msg) {
        UserMessage message = new UserMessage();
        message.setContent(msg);
        return message;
    }

    public boolean isTimeStampMessage() {
        return msgType == TYPE_TIMESTAMP;
    }

    public boolean isUserMessage() {
        return msgType == TYPE_USER_TEXT || msgType == TYPE_USER_IMAGE || msgType == TYPE_USER_VIDEO
                || msgType == TYPE_USER_EVALUATE_FAQ || msgType == TYPE_USER_FILE || msgType == TYPE_USER_EVALUATE_SERVICE;
    }

    public boolean isAgentMessage() {
        return msgType == TYPE_AGENT_TEXT || msgType == TYPE_AGENT_IMAGE || msgType == TYPE_AGENT_VIDEO ||
                msgType == TYPE_AGENT_RPA_FAQ || msgType == TYPE_AGENT_RICH_TEXT
                || msgType == TYPE_AGENT_BOT_ANSWER || msgType == TYPE_AGENT_FILE;
    }

    public boolean isEmptyMessage() {
        return msgType <= 0;
    }

}
