package net.aihelp.data.model.rpa.msg.bot;

import android.os.Parcel;
import android.os.Parcelable;

public class SelfService implements Parcelable {

    private final boolean enableSend;
    private final String selfServiceData;

    public SelfService(boolean enableSend, String selfServiceData) {
        this.enableSend = enableSend;
        this.selfServiceData = selfServiceData;
    }

    protected SelfService(Parcel in) {
        enableSend = in.readByte() != 0;
        selfServiceData = in.readString();
    }

    public static final Creator<SelfService> CREATOR = new Creator<SelfService>() {
        @Override
        public SelfService createFromParcel(Parcel in) {
            return new SelfService(in);
        }

        @Override
        public SelfService[] newArray(int size) {
            return new SelfService[size];
        }
    };

    public boolean isEnableSend() {
        return enableSend;
    }

    public String getSelfServiceData() {
        return selfServiceData;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte((byte) (enableSend ? 1 : 0));
        dest.writeString(selfServiceData);
    }
}
