package net.aihelp.data.track.resource;

import android.text.TextUtils;

import net.aihelp.BuildConfig;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.localize.LocalizeHelper;
import net.aihelp.data.localize.util.LocalizeUtil;
import net.aihelp.data.track.event.EventTracker;
import net.aihelp.data.track.event.utils.EventType;
import net.aihelp.data.track.resource.tracker.InitEventTracker;
import net.aihelp.data.track.resource.tracker.InitResTracker;
import net.aihelp.data.track.resource.tracker.TemplateResTracker;
import net.aihelp.utils.DeviceInfoUtil;
import net.aihelp.utils.DeviceUuidFactory;

import org.json.JSONObject;

import java.util.HashMap;
import java.util.Set;

public class SyncHelper {

    private static final int RESOURCE_REQUEST_THRESHOLD = 5000;

    public static void syncResultToServer(int mode, boolean isSuccess, int fetchSource) {
        long duration = -1;
        HashMap<String, Long> loadingMap = null;
        if (fetchSource == LocalizeHelper.FETCH_SOURCE_INIT) {
            duration = InitResTracker.INSTANCE.getRequestDuration();
            loadingMap = InitResTracker.INSTANCE.getLoadingMap();
        } else if (fetchSource == LocalizeHelper.FETCH_SOURCE_TEMPLATE) {
            duration = TemplateResTracker.INSTANCE.getRequestDuration();
            loadingMap = TemplateResTracker.INSTANCE.getLoadingMap();
        }

        String key = LocalizeUtil.getFolderName(mode).replace("/", "");
        if (loadingMap != null) {
            loadingMap.put(key, isSuccess ? duration : -1);
        }

        if (InitResTracker.INSTANCE.isReady() && fetchSource == LocalizeHelper.FETCH_SOURCE_INIT
                || TemplateResTracker.INSTANCE.isReady() && fetchSource == LocalizeHelper.FETCH_SOURCE_TEMPLATE) {
            syncToServer(duration, loadingMap);
        }
    }

    private static void syncToServer(long duration, HashMap<String, Long> loadingMap) {
        AIHelpRequest request = AIHelpRequest.getInstance();
        JSONObject trackData = getTrackData(duration, loadingMap);
        if (duration >= RESOURCE_REQUEST_THRESHOLD) {
            request.requestPostByJson(API.TRACK_LOCALIZE_DURATION_EXTREME, trackData, null);
        } else {
            request.requestPostByJson(API.TRACK_LOCALIZE_DURATION, trackData, null);
        }
    }

    public static JSONObject getTrackData(long loadingDuration, HashMap<String, Long> loadingMap) {
        JSONObject trackData = getCommonParams();
        JsonHelper.put(trackData, "success", InitEventTracker.INSTANCE.isInitSuccess());
        JsonHelper.put(trackData, "initLoadingTime", InitEventTracker.INSTANCE.getInitDuration());
        JsonHelper.put(trackData, "sdkSettingLoadingTime", loadingDuration);
        if (loadingMap != null) {
            JSONObject sdkSettingDict = JsonHelper.getJsonObject();
            Set<String> resourceKeys = loadingMap.keySet();
            for (String resourceKey : resourceKeys) {
                Long duration = loadingMap.get(resourceKey);
                if (!TextUtils.isEmpty(resourceKey) && duration != null) {
                    JsonHelper.put(sdkSettingDict, resourceKey, duration);
                }
            }
            JsonHelper.put(trackData, "sdkSettingDict", sdkSettingDict);
        }
        return trackData;
    }

    public static JSONObject getCommonParams() {
        JSONObject map = new JSONObject();
        try {
            map.put("time", String.valueOf(System.currentTimeMillis()));
            map.put("deviceId", DeviceUuidFactory.id(AIHelpContext.getInstance().getContext()));
            map.put("countryCode", DeviceInfoUtil.getInstance().getSimCountryIso());
            map.put("userId", UserProfile.USER_ID);
            map.put("platform", BuildConfig.SDK_PLATFORM);
            map.put("lan", Const.CORRECT_LANGUAGE);
            map.put("appId", Const.APP_ID);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static void reset() {
        InitEventTracker.INSTANCE.reset();
        InitResTracker.INSTANCE.reset();
        TemplateResTracker.INSTANCE.reset();
    }

}
