package net.aihelp.data.track.resource.tracker;

import net.aihelp.data.track.event.EventTracker;
import net.aihelp.data.track.event.utils.EventType;

import java.util.HashMap;

public enum InitResTracker {

    INSTANCE;

    private long initResRequestTime = -1;
    private int initResourceCount = -1;
    private HashMap<String, Long> loadingMap = new HashMap<>();

    public void onRequested(int resourceCount) {
        initResRequestTime = System.currentTimeMillis();
        initResourceCount = resourceCount;
        if (initResourceCount == 0) {
        }
    }

    public void onRetrieved() {
        initResourceCount = initResourceCount - 1;
        if (initResourceCount == 0) {
            // post a notification for init resource all downloaded
        }
    }

    public boolean isReady() {
        return initResRequestTime > 0 && initResourceCount == 0;
    }

    public long getRequestDuration() {
        if (initResRequestTime > 0) {
            return System.currentTimeMillis() - initResRequestTime;
        }
        return -1;
    }

    public void reset() {
        initResRequestTime = -1;
        initResourceCount = -1;
        loadingMap = new HashMap<>();
    }

    public HashMap<String, Long> getLoadingMap() {
        return loadingMap;
    }
}
