package net.aihelp.data.track.resource.tracker;

import net.aihelp.core.util.bus.EventBus;
import net.aihelp.data.event.TemplateReadyEvent;
import net.aihelp.data.track.event.EventTracker;
import net.aihelp.data.track.event.utils.EventType;
import net.aihelp.utils.TLog;

import java.util.HashMap;

public enum TemplateResTracker {

    INSTANCE;

    private long requestStartTime = -1;
    private int templateResourceCount = -1;
    private HashMap<String, Long> loadingMap = new HashMap<>();

    public void onRequested(int resourceCount) {
        requestStartTime = System.currentTimeMillis();
        templateResourceCount = resourceCount;
        if (templateResourceCount == 0) {
            // EventTracker.INSTANCE.log(EventType.TEMPLATE_RESOURCE_PREPARED);
            // all the template resources have been prepared, but the event bus may not be registered yet
            if (EventBus.getDefault().hasSubscriberForEvent(TemplateReadyEvent.class)) {
                EventBus.getDefault().post(new TemplateReadyEvent());
            }
        }
    }

    public void onRetrieved() {
        templateResourceCount = templateResourceCount - 1;
        if (templateResourceCount == 0) {
            EventTracker.INSTANCE.log(EventType.TEMPLATE_RESOURCE_PREPARED);
            EventBus.getDefault().post(new TemplateReadyEvent());
        }
    }

    public boolean isReady() {
        return requestStartTime > 0 && templateResourceCount == 0;
    }

    public long getRequestDuration() {
        if (requestStartTime > 0) {
            return System.currentTimeMillis() - requestStartTime;
        }
        return -1;
    }

    public void reset() {
        requestStartTime = -1;
        templateResourceCount = -1;
        loadingMap = new HashMap<>();
    }

    public HashMap<String, Long> getLoadingMap() {
        return loadingMap;
    }
}
