package net.aihelp.data.track.statistic;

import net.aihelp.BuildConfig;
import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.UserProfile;
import net.aihelp.config.AIHelpContext;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.utils.DeviceInfoUtil;
import net.aihelp.utils.DeviceUuidFactory;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TrackHelper {

    public static void syncTrack(JSONArray trackEventArray) {
        if (trackEventArray != null) {
            JSONArray groupedArray = groupArray(trackEventArray, 50);
            for (int i = 0; i < groupedArray.length(); i++) {
                try {
                    JSONArray groupList = groupedArray.getJSONArray(i);
                    AIHelpRequest.getInstance().requestPostByJson(API.TRACK_RPA, groupList.toString(), null);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    // region - 数据处理相关
    private static JSONArray groupArray(JSONArray originArray, int count) {
        JSONArray resultArray = new JSONArray();
        if (originArray != null) {
            int number = originArray.length() / count + (originArray.length() % count > 0 ? 1 : 0);
            for (int i = 0; i < number; i++) {
                JSONArray groupedArray = new JSONArray();
                for (int j = count * i; j < Math.min(count * i + count, originArray.length()); j++) {
                    groupedArray.put(JsonHelper.getJsonObject(originArray, j));
                }
                resultArray.put(groupedArray);
            }
        }
        return resultArray;
    }

    public static void addTrackData(JSONObject object, String key, Object value) {
        try {
            if (object != null) {
                object.put(key, value);
            }
        } catch (Exception e) {
            // ignored
        }
    }

    public static JSONObject getCommonParams(int traceType, TrackEntity trackEntity, JSONObject... extendData) {
        JSONObject map = new JSONObject();
        try {
            map.put("time", String.valueOf(System.currentTimeMillis()));
            map.put("statsType", traceType);
            if (trackEntity != null) {
                map.put("entranceId", trackEntity.getEntranceId());
                map.put("activeId", trackEntity.getActiveId());
            }
            map.put("deviceId", DeviceUuidFactory.id(AIHelpContext.getInstance().getContext()));
            map.put("countryCode", DeviceInfoUtil.getInstance().getSimCountryIso());
            map.put("userId", UserProfile.USER_ID);
            map.put("platform", BuildConfig.SDK_PLATFORM);
            map.put("lan", Const.CORRECT_LANGUAGE);
            map.put("appId", Const.APP_ID);
            if (extendData != null && extendData.length > 0) {
                map.put("extendData", extendData[0]);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

}
