package net.aihelp.data.track.ue;

import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.track.event.utils.EventType;
import net.aihelp.utils.TLog;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class UETracker {

    public static final int DURATION_TEMPLATE_DOWNLOADING = 1;
    public static final int DURATION_CS_LOADING = 2;
    public static final int DURATION_FORM_RENDERING = 3;
    public static final int COUNT_ERROR_ENTRANCE = 4;
    public static final int AIHELP_IN_STACK = 5;

    public static HashMap<Integer, List<Long>> calculateUETrack(String content) {
        HashMap<Integer, List<Long>> result = getResult(content);

        List<Long> downloadTemplateDuration = result.get(DURATION_TEMPLATE_DOWNLOADING);

        List<Long> csLoadingDuration = result.get(DURATION_CS_LOADING);

        List<Long> webRenderDuration = result.get(DURATION_FORM_RENDERING);

        List<Long> errEntranceCounts = result.get(COUNT_ERROR_ENTRANCE);
        int errCount = errEntranceCounts != null ? errEntranceCounts.size() : 0;

        boolean forceExitInAIHelp = result.containsKey(AIHELP_IN_STACK);

        TLog.d("UETracker", String.format("downloadTemplateDuration: %s, csLoadingDuration: %s, webRenderDuration: %s, errCount: %s, forceExit: %s",
                downloadTemplateDuration, csLoadingDuration, webRenderDuration, errCount, forceExitInAIHelp));

        return result;
    }

    private static HashMap<Integer, List<Long>> getResult(String content) {
        HashMap<Integer, Long> mapStartTime = new HashMap<>();
        HashMap<Integer, List<Long>> mapList = new HashMap<>();

        JSONArray eventArray = JsonHelper.getJsonArray(content);
        for (int i = 0; i < eventArray.length(); i++) {
            JSONObject eventObject = JsonHelper.getJsonObject(eventArray, i);
            long eventType = eventObject.optInt("type", 0);
            long time = eventObject.optLong("time", -1);

            if (eventType == EventType.API_SHOW) {
                mapStartTime.put(DURATION_TEMPLATE_DOWNLOADING, time);
            }

            if (eventType == EventType.TEMPLATE_RESOURCE_PREPARED) {
                Long timeSDKOpened = mapStartTime.get(DURATION_TEMPLATE_DOWNLOADING);
                if (timeSDKOpened != null) {
                    List<Long> openSdkDurationEvents = mapList.get(DURATION_TEMPLATE_DOWNLOADING);
                    if (openSdkDurationEvents == null) openSdkDurationEvents = new ArrayList<>();
                    openSdkDurationEvents.add(time - timeSDKOpened);
                    mapList.put(DURATION_TEMPLATE_DOWNLOADING, openSdkDurationEvents);
                    // remove anchor time after putting new value
                    mapStartTime.remove(DURATION_TEMPLATE_DOWNLOADING);
                }
                mapList.put(AIHELP_IN_STACK, null);
            }

            if (eventType == EventType.CS_PAGE_OPENED) {
                mapStartTime.put(DURATION_CS_LOADING, time);
            }

            if (eventType == EventType.CS_CONNECT_MQTT) {
                Long timeLoadingBegan = mapStartTime.get(DURATION_CS_LOADING);
                if (timeLoadingBegan != null) {
                    List<Long> loadingDurationEvents = mapList.get(DURATION_CS_LOADING);
                    if (loadingDurationEvents == null) loadingDurationEvents = new ArrayList<>();
                    loadingDurationEvents.add(time - timeLoadingBegan);
                    mapList.put(DURATION_CS_LOADING, loadingDurationEvents);
                    // remove anchor time after putting new value
                    mapStartTime.remove(DURATION_CS_LOADING);
                }
            }

            if (eventType == EventType.CS_CLICK_URL) {
                mapStartTime.put(DURATION_FORM_RENDERING, time);
            }

            if (eventType == EventType.WEB_LOAD_FINISHED) {
                Long timeUrlClicked = mapStartTime.get(DURATION_FORM_RENDERING);
                if (timeUrlClicked != null) {
                    List<Long> webRenderDurationEvents = mapList.get(DURATION_FORM_RENDERING);
                    if (webRenderDurationEvents == null) webRenderDurationEvents = new ArrayList<>();
                    webRenderDurationEvents.add(time - timeUrlClicked);
                    mapList.put(DURATION_FORM_RENDERING, webRenderDurationEvents);
                    // remove anchor time after putting new value
                    mapStartTime.remove(DURATION_FORM_RENDERING);
                }
            }

            if (eventType == EventType.ERR_NO_ENTRANCE_MATCHED) {
                List<Long> errEntranceEvents = mapList.get(COUNT_ERROR_ENTRANCE);
                if (errEntranceEvents == null) errEntranceEvents = new ArrayList<>();
                errEntranceEvents.add(time);
                mapList.put(COUNT_ERROR_ENTRANCE, errEntranceEvents);
            }

            if (eventType == EventType.AIHELP_DESTROYED) {
                mapList.remove(AIHELP_IN_STACK);
            }

        }
        return mapList;
    }

}
