package net.aihelp.ui.adapter.cs.agent;

import android.content.Context;
import android.widget.TextView;

import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.rpa.msg.BotMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.msg.UserMessage;
import net.aihelp.data.model.rpa.msg.bot.Answer;
import net.aihelp.data.model.rpa.msg.bot.Faq;
import net.aihelp.data.track.statistic.StatisticTracker;
import net.aihelp.data.logic.cs.TicketStatusTracker;
import net.aihelp.ui.widget.AIHelpEvaluateButtonView;
import net.aihelp.utils.FastClickValidator;
import net.aihelp.utils.Styles;

import org.json.JSONObject;

import java.util.List;

public class AgentAnswerAdapter extends AgentFaqAdapter {

    private AIHelpEvaluateButtonView mEvaluateButtonView;

    public AgentAnswerAdapter(Context context) {
        super(context);
    }

    @Override
    public boolean isForViewType(Message message, int position) {
        return message.getMsgType() == Message.TYPE_AGENT_BOT_ANSWER;
    }

    @Override
    public void convert(final ViewHolder holder, Message message, int position) {
        super.convert(holder, message, position);

        if (message instanceof BotMessage) {
            BotMessage botMessage = (BotMessage) message;
            if (botMessage.hasBotAnswers()) {
                List<Answer> botAnswers = botMessage.getBotAnswers();
                if (isSingleFaqMatched(botMessage)) {
                    llContainer.removeAllViews(); // 单条时不需要提示语
                    Answer answer = ((BotMessage) message).getBotAnswers().get(0);
                    llContainer.addView(getSingleFAQItem(botMessage, answer.getFaqData()));
                    if (answer.getFaqData().hasAttachedForm()) {
                        prepareFaqFormLayout(llContainer, answer.getFaqData());
                    }
                    prepareEvaluateLayout(holder, botMessage, answer.getFaqData());
                } else {
                    for (int i = 0; i < botAnswers.size(); i++) {
                        Answer answer = botAnswers.get(i);
                        llContainer.addView(getListItem(i + 1, botMessage, answer));
                    }
                }
            }
        }

    }

    // region - 判断是否命中了单条 FAQ
    private boolean isSingleFaqMatched(BotMessage botMessage) {
        if (botMessage.hasBotAnswers() && botMessage.getBotAnswers().size() == 1) {
            Answer answer = botMessage.getBotAnswers().get(0);
            return answer.getType() == Answer.ANSWER_TYPE_FAQ && answer.getFaqData() != null;
        }
        return false;
    }
    // endregion

    // region - 命中多条 FAQ 数据或 RPA 机器人时的逻辑处理

    /**
     * 1、默认覆盖父级的点击事件，改为点击后发送消息；
     * 2、如果进入 RPA 或人工流程后，重置该属性，让点击事件保持原样，即点击后查看 FAQ
     * 2.1、如果是 FAQ 的话，如果是 RPA 流程则 faqData 为空，点击事件中做了空判断处理
     */
    private TextView getListItem(int index, BotMessage botMessage, Answer answer) {
        final String answerTitle = answer.getTitle();
        Faq.FaqData faqData = answer.getFaqData();
        TextView multipleFaqItem = super.getListItem(index, answerTitle, botMessage, faqData);
        multipleFaqItem.setOnClickListener(v -> {
            if (TicketStatusTracker.isTicketServingByAnswerBot()) {
                sendRPAMessageWithBotAnswer(answerTitle);
            } else {
                botMessage.setUserFeedback(BotMessage.USER_FEEDBACK_INVISIBLE);
                checkoutFaqDetail(botMessage, faqData);
            }
        });
        return multipleFaqItem;
    }

    private void sendRPAMessageWithBotAnswer(String answerTitle) {
        if (mWrapper != null && FastClickValidator.validate()) {
            UserMessage rpaMessage = Message.getUserTextMsg(answerTitle);
            rpaMessage.setRequestParams(answerTitle, UserMessage.INPUT_FORMAT_TEXT, UserMessage.INPUT_SOURCE_ANSWER_BOT);
            mWrapper.onBotAnswerSelected(rpaMessage);
            StatisticTracker.getInstance().onAnswerBotSelected();
        }
    }
    // endregion

    // 处理 FAQ 点赞点踩相关业务
    private void prepareEvaluateLayout(ViewHolder holder, BotMessage botMessage, Faq.FaqData faq) {
        mEvaluateButtonView = holder.getView(getViewId("aihelp_evaluate_view"));
        mEvaluateButtonView.setMaxWidth(Styles.getScreenWidth(mContext) - Styles.dpToPx(mContext, 110));
        mEvaluateButtonView.refreshViewState(botMessage.getUserFeedback());
        mEvaluateButtonView.setOnAIHelpEvaluateViewCallback(new AIHelpEvaluateButtonView.OnAIHelpEvaluateViewCallback() {
            @Override
            public void onEvaluated(boolean isHelpful) {
                botMessage.setUserFeedback(isHelpful ? BotMessage.USER_FEEDBACK_POSITIVE : BotMessage.USER_FEEDBACK_NEGATIVE);
                llContainer.setMinimumWidth(mEvaluateButtonView.getMinWidth());
            }

            @Override
            public JSONObject requestDataForFeedback() {
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("mainId", faq.getMainId());
                    jsonObject.put("contentId", faq.getContentId());
                    jsonObject.put("isClickDetail", faq.isFaqViewed());
                    jsonObject.put("pointMessageId", String.valueOf(botMessage.getTimestamp()));
                } catch (Exception e) {
                    // ignored
                }
                return jsonObject;
            }
        });
        llContainer.setMinimumWidth(mEvaluateButtonView.getMinWidth());
    }

    @Override
    public void onEvaluated(BotMessage botMessage, boolean isHelpful) {
        if (mEvaluateButtonView != null) {
            mEvaluateButtonView.refreshViewState(botMessage.getUserFeedback());
        }
    }

}
