package net.aihelp.ui.adapter.cs.agent;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.rpa.msg.BotMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.msg.bot.Faq;
import net.aihelp.data.track.statistic.StatisticTracker;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.cs.viewer.BotFaqViewer;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.FastClickValidator;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import java.util.List;

public class AgentFaqAdapter extends BaseMsgAdapter implements BotFaqViewer.OnFaqEvaluateListener {

    protected LinearLayout llContainer;

    public AgentFaqAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_agent_faq_like");
    }

    @Override
    public boolean isForViewType(Message message, int position) {
        return message.getMsgType() == Message.TYPE_AGENT_RPA_FAQ;
    }

    @Override
    public void convert(final ViewHolder holder, Message message, int position) {

        if (message instanceof BotMessage) {
            BotMessage botMessage = (BotMessage) message;

            Styles.loadIcon(holder.getView(getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csBotSupportPortrait,
                    CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_robot");

            Styles.reRenderTextView(holder.getView(getViewId("aihelp_tv_nickname")),
                    botMessage.getNickname(),
                    Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8),
                    CustomConfig.CustomerService.isNicknameVisible && !TextUtils.isEmpty(botMessage.getNickname()),
                    13);

            llContainer = holder.getView(getViewId("aihelp_agent_faq_container"));
            llContainer.setBackground(getAdminBackgroundDrawable(isCurrentRtl));
            llContainer.removeAllViews();

            llContainer.addView(getMsg(botMessage.getContent(), botMessage.isEnableInteraction()));

            if (botMessage.hasFaq()) {
                List<Faq.FaqData> faqDataList = botMessage.getFaq().getFaqDataList();
                if (faqDataList.size() == 1) {
                    Faq.FaqData faqData = faqDataList.get(0);
                    llContainer.addView(getSingleFAQItem(botMessage, faqData));
                    if (faqData.hasAttachedForm()) {
                        prepareFaqFormLayout(llContainer, faqData);
                    }
                } else {
                    for (int i = 0; i < faqDataList.size(); i++) {
                        Faq.FaqData faqData = faqDataList.get(i);
                        llContainer.addView(getListItem(i + 1, faqData.getFaqTitle(), botMessage, faqData));
                    }
                }
            }

            // 隐藏点赞点踩相关布局，RPA 呼出的 FAQ 永远不会有 cell 的点赞点踩样式
            holder.setVisible(getViewId("aihelp_evaluate_view"), false);
        }
    }

    protected TextView getListItem(int index, String title, BotMessage botMessage, Faq.FaqData faqData) {
        TextView textView = new TextView(mContext);
        textView.setClickable(true);
        Styles.reRenderTextView(textView, String.format("%s", title), Color.parseColor(CustomConfig.CommonSetting.interactElementTextColor));
        textView.setOnClickListener(getFaqViewer(botMessage, faqData));
        textView.setPadding(0, dip2px(mContext, 5), 0, dip2px(mContext, 0));
        return textView;
    }

    protected View getSingleFAQItem(BotMessage botMessage, final Faq.FaqData faqData) {
        LinearLayout layout = new LinearLayout(mContext);
        layout.setOrientation(LinearLayout.VERTICAL);

        if (!TextUtils.isEmpty(faqData.getTemplate())) {
            TextView faqContent = new TextView(mContext);
            faqContent.setLineSpacing(dip2px(mContext, 3), 1.0f);
            Styles.reRenderTextView(faqContent, faqData.getTemplate());
            layout.addView(faqContent);
        }

        TextView tvShowMore = new TextView(mContext);
        tvShowMore.setLayoutParams(new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT));
        Styles.reRenderTextView(tvShowMore, ResResolver.getString("aihelp_view_details"),
                Color.parseColor(CustomConfig.CommonSetting.interactElementTextColor));
        tvShowMore.setGravity(Gravity.CENTER);
        tvShowMore.setLineSpacing(dip2px(mContext, 3), 1.0f);
        tvShowMore.setPadding(0, dip2px(mContext, 7), 0, dip2px(mContext, 7));
        tvShowMore.setOnClickListener(getFaqViewer(botMessage, faqData));
        tvShowMore.setVisibility(faqData.isShowMore() ? View.VISIBLE : View.GONE);
        layout.addView(tvShowMore);

        // if the faq is short enough and it's the first time the FaqCardLayout is rendered,
        // consider this faq as viewed and track the FaqChecked event,
        // then update this faq's `isFaqViewed` field to avoid extra tracking during the adapter's reuse procedure
        if (!faqData.isShowMore() && !faqData.isFaqViewed()) {
            faqData.setFaqViewed(true);
            trackAnswerFaqChecked(faqData);
        }

        return layout;
    }

    protected void prepareFaqFormLayout(LinearLayout container, final Faq.FaqData faqData) {

        View divider = new View(mContext);
        divider.setBackgroundColor(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.1f));
        divider.setLayoutParams(new ViewGroup.MarginLayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, dip2px(mContext, 1)));
        divider.setPadding(0, dip2px(mContext, 10), 0, 0);
        container.addView(divider);

        TextView tvHint = new TextView(mContext);
        tvHint.setLayoutParams(new ViewGroup.MarginLayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT));
        tvHint.setPadding(0, dip2px(mContext, 10), 0, 0);
        Styles.reRenderTextView(tvHint, ResResolver.getString("aihelp_form_hint"));
        container.addView(tvHint);

        TextView formUrl = getHighlightedClickableTextView(faqData.getFormTitle(), new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String formUrl = faqData.getFormUrl();
                if (AppInfoUtil.isUrlStillNeedResponding(mContext, formUrl)) {
                    if (mWrapper != null) {
                        mWrapper.onUrlClicked(true, formUrl);
                    }
                }
            }
        });
        formUrl.setLayoutParams(new ViewGroup.MarginLayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT));
        formUrl.setTypeface(Typeface.defaultFromStyle(Typeface.BOLD));
        formUrl.setPadding(0, dip2px(mContext, 5), 0, 0);
        container.addView(formUrl);
    }

    private View.OnClickListener getFaqViewer(BotMessage botMessage, Faq.FaqData faqData) {
        return v -> checkoutFaqDetail(botMessage, faqData);
    }

    protected void checkoutFaqDetail(BotMessage botMessage, Faq.FaqData faqData) {
        if (faqData != null && FastClickValidator.validate()) {
            faqData.setFaqViewed(true);
            trackAnswerFaqChecked(faqData);
            BotFaqViewer.INSTANCE.show(mContext, botMessage, faqData, this);
        }
    }

    private void trackAnswerFaqChecked(Faq.FaqData faqData) {
        String mainId = String.valueOf(faqData.getMainId());
        String contentId = String.valueOf(faqData.getContentId());
        StatisticTracker.getInstance().checkedFAQInBot(faqData.getFaqSource(), mainId, contentId);
    }

    @Override
    public void onEvaluated(BotMessage botMessage, boolean isHelpful) {

    }

}
