package net.aihelp.ui.adapter.cs.agent;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.rpa.msg.base.FileMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.preview.PreviewActivity;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import androidx.fragment.app.Fragment;

public class AgentFileAdapter extends BaseMsgAdapter {

    public AgentFileAdapter(Context context, Fragment fragment) {
        super(context, fragment);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_agent_file");
    }

    @Override
    public boolean isForViewType(Message message, int position) {
        return message.getMsgType() == Message.TYPE_AGENT_FILE;
    }

    @Override
    public void convert(ViewHolder holder, final Message message, final int position) {
        if (message instanceof FileMessage) {
            FileMessage fileMessage = (FileMessage) message;

            Styles.loadIcon(holder.getView(getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csManualSupportPortrait,
                    CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_agent");

            Styles.reRenderTextView(holder.getView(getViewId("aihelp_tv_nickname")),
                    fileMessage.getNickname(),
                    Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8),
                    CustomConfig.CustomerService.isNicknameVisible && !TextUtils.isEmpty(fileMessage.getNickname()),
                    13);

            RelativeLayout rlContainer = holder.getView(getViewId("aihelp_rl_file_container"));
            rlContainer.setBackground(getAdminBackgroundDrawable(isCurrentRtl));
            rlContainer.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    PreviewInfo previewInfo = PreviewInfo.get(fileMessage.getContent(), fileMessage.getFileName());
                    PreviewActivity.startAct(mFragment, previewInfo);
                }
            });

            TextView tvFileName = holder.getView(getViewId("aihelp_tv_file_name"));
            tvFileName.setMaxWidth(getRightfulMaxWidthForFileName());
            Styles.reRenderTextView(tvFileName, fileMessage.getFileName(),
                    Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8), true, 14);

            Styles.reRenderTextView(holder.getView(getViewId("aihelp_tv_file_size")),
                    fileMessage.getFileSize(),
                    Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8), true, 14);

            ImageView ivFile = holder.getView(getViewId("aihelp_iv_file"));
            renderImageViewWithFixedWidthAndHeight(ivFile, "aihelp_svg_ic_file", 36, 45);

            ImageView ivDownload = holder.getView(getViewId("aihelp_iv_download"));
            renderImageViewWithFixedWidthAndHeight(ivDownload, "aihelp_svg_ic_download", 23, 20);
            ivDownload.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    AppInfoUtil.openWithBrowser(mContext, message.getContent());
                }
            });
        }
    }

    protected void renderImageViewWithFixedWidthAndHeight(ImageView imageView, String svgResource, int width, int height) {
        imageView.setImageDrawable(Styles.getClickableDrawable(mContext, svgResource,
                Styles.getColor(CustomConfig.CommonSetting.highlightedColor), false));
        ViewGroup.LayoutParams layoutParams = imageView.getLayoutParams();
        layoutParams.width = dip2px(mContext, getScaledSize(width));
        layoutParams.height = dip2px(mContext, getScaledSize(height));
        imageView.setLayoutParams(layoutParams);
    }

    protected int getRightfulMaxWidthForFileName() {
        int maxWidth = Styles.getScreenWidth(mContext)
                - dip2px(mContext, 10) // message container leading margin
                - dip2px(mContext, 20) // message container left and right padding
                - dip2px(mContext, getScaledSize(36)) // file icon width
                - dip2px(mContext, 20) // file icon and download icon's right margin
                - dip2px(mContext, getScaledSize(23)) // download icon width
                - dip2px(mContext, 60);// right margin of whole layout offset the screen
        if (CustomConfig.CustomerService.isPortraitVisible) {
            maxWidth = maxWidth - dip2px(mContext, 40) // portrait
                    - dip2px(mContext, 10); // portrait leading margin
        }
        return maxWidth;
    }

    protected float getScaledSize(float size) {
        return size * Math.min(1.3f, CustomConfig.CommonSetting.scaleFactor);
    }

}
