package net.aihelp.ui.adapter.cs.agent;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.rpa.msg.agent.AgentRichMessage;
import net.aihelp.data.model.rpa.msg.base.FileMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.preview.PreviewActivity;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ListUtil;
import net.aihelp.utils.MediaUtils;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import java.io.File;
import java.util.List;

import androidx.fragment.app.Fragment;

public class AgentRichTextAdapter extends AgentFileAdapter {

    public AgentRichTextAdapter(Context context, Fragment fragment) {
        super(context, fragment);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_agent");
    }

    @Override
    public boolean isForViewType(Message message, int position) {
        return message.getMsgType() == Message.TYPE_AGENT_RICH_TEXT;
    }

    @Override
    public void convert(ViewHolder holder, Message message, int position) {

        LinearLayout llContainer = holder.getView(getViewId("aihelp_agent_message_container"));
        llContainer.setBackground(getAdminBackgroundDrawable(isCurrentRtl));
        llContainer.removeAllViews();

        Styles.loadIcon(holder.getView(getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csManualSupportPortrait,
                CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_agent");

        Styles.reRenderTextView(holder.getView(getViewId("aihelp_tv_nickname")),
                message.getNickname(),
                Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8),
                CustomConfig.CustomerService.isNicknameVisible && !TextUtils.isEmpty(message.getNickname()),
                13);

        convertSupportTextMsg(holder, llContainer, message);

    }

    private void convertSupportTextMsg(ViewHolder holder, ViewGroup container, Message message) {
        holder.setVisible(getViewId("aihelp_tv_nickname"), CustomConfig.CustomerService.isNicknameVisible && !TextUtils.isEmpty(message.getNickname()));
        holder.setTextColor(getViewId("aihelp_tv_nickname"), Color.parseColor(CustomConfig.CommonSetting.textColor));
        container.addView(getRichTextMsg(message));
    }

    /**
     * 加载富文本消息，有可能同时出现：多个图片、多个表单以及多段文本
     */
    protected View getRichTextMsg(final Message message) {
        LinearLayout layout = new LinearLayout(mContext);
        layout.setOrientation(LinearLayout.VERTICAL);
        layout.setGravity(Gravity.START);
        layout.setLayoutParams(new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT));

        if (message instanceof AgentRichMessage) {
            AgentRichMessage richMessage = (AgentRichMessage) message;
            List<Message> messageList = richMessage.getMessageList();
            if (!ListUtil.isListEmpty(messageList)) {
                for (Message msg : messageList) {
                    switch (msg.getMsgType()) {
                        case Message.TYPE_AGENT_TEXT:
                            layout.addView(getTextViewFromRichText(msg.getContent()));
                            break;
                        case Message.TYPE_AGENT_IMAGE:
                            layout.addView(getImageViewFromRichText(msg.getContent()));
                            break;
                        case Message.TYPE_AGENT_VIDEO:
                            layout.addView(getVideoViewFromRichText(msg.getContent()));
                            break;
                        case Message.TYPE_AGENT_FILE:
                            layout.addView(getAttachmentViewFromRichText(msg));
                            break;
                    }
                }
            }
        }
        return layout;
    }

    private View getImageViewFromRichText(String imageUrl) {
        final ImageView imageView = new ImageView(mContext);
        LinearLayout.MarginLayoutParams layoutParams = new ViewGroup.MarginLayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT,
                ViewGroup.LayoutParams.WRAP_CONTENT);
        layoutParams.topMargin = Styles.dpToPx(mContext, 3);
        imageView.setLayoutParams(layoutParams);
        imageView.setAdjustViewBounds(true);
        MediaUtils.scaleImageView(imageUrl, imageView, imageView, null);
        imageView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                PreviewActivity.startAct(mFragment, PreviewInfo.get(imageUrl));
            }
        });
        return imageView;
    }

    private View getVideoViewFromRichText(String videoUrl) {
        View rootView = View.inflate(mContext, ResResolver.getLayoutId("aihelp_loading_image_view"), null);
        ImageView imageView = rootView.findViewById(ResResolver.getViewId("aihelp_image_view"));
        ImageView ivPlay = rootView.findViewById(ResResolver.getViewId("aihelp_iv_play"));
        View maskView = rootView.findViewById(ResResolver.getViewId("aihelp_v_mask"));
        View loadingView = rootView.findViewById(ResResolver.getViewId("aihelp_loading_view"));
        rootView.setLayoutParams(new LinearLayout.LayoutParams(dip2px(mContext, 120), dip2px(mContext, 150)));

        MediaUtils.getImageForVideo(videoUrl, new MediaUtils.OnLoadVideoImageListener() {
            @Override
            public void onLoadImage(File file) {
                MediaUtils.scaleImageView(file.getAbsolutePath(), imageView, rootView, new MediaUtils.OnImageScaledListener() {
                    @Override
                    public void onImageScaled() {
                        maskView.setVisibility(View.GONE);
                        loadingView.setVisibility(View.GONE);
                        ivPlay.setVisibility(View.VISIBLE);
                    }
                });

                rootView.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        PreviewActivity.startAct(mFragment, PreviewInfo.get(videoUrl));
                    }
                });
            }
        });

        return rootView;
    }

    private View getAttachmentViewFromRichText(Message message) {
        if (message instanceof FileMessage) {
            FileMessage fileMessage = (FileMessage) message;
            View rootView = View.inflate(mContext, ResResolver.getLayoutId("aihelp_layout_rich_text_attachment"), null);
            rootView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    PreviewInfo previewInfo = PreviewInfo.get(fileMessage.getContent(), fileMessage.getFileName());
                    PreviewActivity.startAct(mFragment, previewInfo);
                }
            });

            TextView tvFileName = rootView.findViewById(ResResolver.getViewId("aihelp_tv_file_name"));
            Styles.reRenderTextView(tvFileName, fileMessage.getFileName(),
                    Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8), true, 14);
            tvFileName.measure(0, 0);
            ViewGroup.LayoutParams tvFileNameLayoutParams = tvFileName.getLayoutParams();
            tvFileNameLayoutParams.width = Math.min(tvFileName.getMeasuredWidth(), super.getRightfulMaxWidthForFileName());
            tvFileName.setLayoutParams(tvFileNameLayoutParams);

            TextView tvFileSize = rootView.findViewById(ResResolver.getViewId("aihelp_tv_file_size"));
            Styles.reRenderTextView(tvFileSize, fileMessage.getFileSize(),
                    Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8), true, 14);

            ImageView ivFile = rootView.findViewById(getViewId("aihelp_iv_file"));
            renderImageViewWithFixedWidthAndHeight(ivFile, "aihelp_svg_ic_file", 36, 45);

            ImageView ivDownload = rootView.findViewById(getViewId("aihelp_iv_download"));
            renderImageViewWithFixedWidthAndHeight(ivDownload, "aihelp_svg_ic_download", 23, 20);
            ivDownload.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    AppInfoUtil.openWithBrowser(mContext, message.getContent());
                }
            });

            rootView.setLayoutParams(new LinearLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT));
            return rootView;
        }
        return null;
    }

    private View getTextViewFromRichText(final String text) {
        TextView textView = getMsg(text, true);
        textView.setLayoutParams(new LinearLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT));
        return textView;
    }

}
