package net.aihelp.ui.adapter.cs.agent;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import net.aihelp.common.API;
import net.aihelp.common.Const;
import net.aihelp.common.CustomConfig;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.http.AIHelpRequest;
import net.aihelp.core.net.http.callback.ReqCallback;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.rpa.msg.BotMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.msg.bot.ExternalUrl;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.cs.viewer.SelfServiceViewer;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.DeviceUuidFactory;
import net.aihelp.utils.FastClickValidator;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import org.json.JSONObject;


public class AgentTextAdapter extends BaseMsgAdapter {

    public AgentTextAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_agent");
    }

    @Override
    public boolean isForViewType(Message item, int position) {
        return item.getMsgType() == Message.TYPE_AGENT_TEXT;
    }

    @Override
    public void convert(ViewHolder holder, Message s, int position) {

        LinearLayout llContainer = holder.getView(getViewId("aihelp_agent_message_container"));

        llContainer.setBackground(getAdminBackgroundDrawable(isCurrentRtl));
        llContainer.removeAllViews();

        boolean isBotAgent = s instanceof BotMessage;
        ImageView ivPortrait = holder.getView(getViewId("aihelp_iv_portrait"));
        Styles.loadIcon(
                ivPortrait,
                isBotAgent ? CustomConfig.CustomerService.csBotSupportPortrait : CustomConfig.CustomerService.csManualSupportPortrait,
                CustomConfig.CustomerService.isPortraitVisible,
                isBotAgent ? "aihelp_svg_portrait_robot" : "aihelp_svg_portrait_agent"
        );

        Styles.reRenderTextView(holder.getView(getViewId("aihelp_tv_nickname")),
                s.getNickname(),
                Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.8),
                CustomConfig.CustomerService.isNicknameVisible && !TextUtils.isEmpty(s.getNickname()),
                13);

        if (isBotAgent) {
            convertElvaBotTextMsg(llContainer, (BotMessage) s);
            holder.setVisible(getViewId("aihelp_iv_translate"), false);
        } else {
            holder.setVisible(getViewId("aihelp_iv_translate"), Const.TOGGLE_TRANSLATE_CS_MESSAGE);
            convertSupportTextMsg(holder, llContainer, s, position);
        }

    }

    private void convertSupportTextMsg(ViewHolder holder, ViewGroup container, Message msg, int position) {
        TextView textView = getMsg(msg.getContent(), msg.isEnableInteraction());
        prepareTranslate(holder, textView, position);
        container.addView(textView);
    }

    private void convertElvaBotTextMsg(ViewGroup container, BotMessage botMsg) {
        if (!TextUtils.isEmpty(botMsg.getContent())) {
            container.addView(getMsg(botMsg.getContent(), botMsg.isEnableInteraction()));
        }

        // 机器人响应的表单链接不在此处展示，只有外链才会在这里显示
        // 但是人工发送的表单还是会在列表里显示
        if (botMsg.hasExternalUrl()) {
            ExternalUrl externalUrl = botMsg.getExternalUrl();
            container.addView(getHighlightedClickableTextView(externalUrl.getTitle(), new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    String urlLink = externalUrl.getLink();
                    if (AppInfoUtil.isUrlStillNeedResponding(mContext, urlLink)) {
                        if (mWrapper != null) {
                            mWrapper.onUrlClicked(false, urlLink);
                        }
                    }
                }
            }));
        }

        if (botMsg.hasSelfService() && !botMsg.getSelfService().isEnableSend()) {
            container.addView(getHighlightedClickableTextView(ResResolver.getString("aihelp_view_details"), new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (mWrapper != null && FastClickValidator.validate()) {
                        new SelfServiceViewer().getService(mContext, botMsg.getSelfService());
                    }
                }
            }));
        }
    }

    private void prepareTranslate(ViewHolder holder, TextView textView, int position) {
        if (Const.TOGGLE_TRANSLATE_CS_MESSAGE) {
            int maxTextWidth = Styles.getScreenWidth(mContext) - (dip2px(mContext, 165));
            textView.setMaxWidth(maxTextWidth);
            String originContent = textView.getText().toString();
            StringBuilder translatedContent = new StringBuilder(originContent);
            holder.setOnClickListener(getViewId("aihelp_iv_translate"), new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    try {
                        JSONObject params = new JSONObject();
                        params.put("deviceId", DeviceUuidFactory.id(mContext));
                        params.put("playerId", UserProfile.USER_ID);
                        params.put("content", originContent);
                        AIHelpRequest.getInstance().requestPostByJson(API.TRANSLATE_MESSAGE, params, new ReqCallback<String>() {
                            @Override
                            public void onReqSuccess(String result) {
                                translatedContent.append("\n---------\n").append(result);
                                textView.setText(translatedContent.toString());
                                textView.setMaxWidth(Integer.MAX_VALUE);
                            }
                        });
                        holder.setVisible(getViewId("aihelp_iv_translate"), false);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

}
