package net.aihelp.ui.adapter.cs.user;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.rpa.msg.UserMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.widget.AIHelpMovementMethod;
import net.aihelp.ui.widget.AIHelpRatingBar;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import androidx.appcompat.widget.AppCompatImageButton;

public class UserEvaluationAdapter extends BaseMsgAdapter {

    public UserEvaluationAdapter(Context context) {
        super(context);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_user_evaluation");
    }

    @Override
    public boolean isForViewType(Message message, int position) {
        return message.getMsgType() == Message.TYPE_USER_EVALUATE_SERVICE;
    }

    @Override
    public void convert(final ViewHolder holder, final Message message, final int position) {

        holder.setBackgroundDrawable(ResResolver.getViewId("aihelp_rl_container"), getUserBackgroundDrawable(isCurrentRtl));

        Styles.loadIcon(holder.getView(getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csUserPortrait,
                CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_user");

        AIHelpRatingBar ratingBar = holder.getView(ResResolver.getViewId("aihelp_rating_bar"));
        if (message instanceof UserMessage) {
            ratingBar.setCurrGrade(((UserMessage) message).getEvaluateGrade());
        }

        TextView tvUserEvaluate = holder.getView(ResResolver.getViewId("aihelp_tv_user_evaluate"));
        Styles.reRenderTextView(tvUserEvaluate,
                message.getContent(),
                Color.WHITE,
                !TextUtils.isEmpty(message.getContent()),
                14
        );
        tvUserEvaluate.post(new Runnable() {
            @Override
            public void run() {
                tvUserEvaluate.setMaxWidth(ratingBar.getMeasuredWidth());
            }
        });

        AppCompatImageButton retryButton = holder.getView(getViewId("aihelp_iv_msg_retry"));
        switch (message.getMsgStatus()) {
            case Message.STATUS_NORMAL:
            case Message.STATUS_SENDING:
                retryButton.setVisibility(View.GONE);
                break;
            case Message.STATUS_FAILURE:
                retryButton.setVisibility(View.VISIBLE);
                retryButton.setImageResource(ResResolver.getDrawableId("aihelp_svg_iv_msg_retry"));
                retryButton.setOnClickListener(getRetryListener(position, message));
                break;
        }

    }

    private int getRightfulMaxWidth(ViewHolder holder) {
        ImageView ivPortrait = holder.getView(getViewId("aihelp_iv_portrait"));
        TextView tvMsg = holder.getView(getViewId("aihelp_user_message_text"));
        return Styles.getScreenWidth(mContext) - (dip2px(mContext, 39) +
                ((ViewGroup.MarginLayoutParams) ivPortrait.getLayoutParams()).rightMargin +
                ((ViewGroup.MarginLayoutParams) tvMsg.getLayoutParams()).rightMargin) * 2;
    }

    private Drawable getUserBackgroundDrawable(boolean isRtl) {
        int colorFromHex = Color.parseColor(CustomConfig.CommonSetting.interactElementTextColor);
        return isRtl ? Styles.getDrawableWithCorner(colorFromHex, 0, 15, 15, 15)
                : Styles.getDrawableWithCorner(colorFromHex, 15, 0, 15, 15);
    }

}
