package net.aihelp.ui.adapter.cs.user;

import android.content.Context;
import android.view.View;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.rpa.msg.base.FileMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.preview.PreviewActivity;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.ui.widget.AIHelpLoadingImageView;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import androidx.fragment.app.Fragment;


public class UserImageAdapter extends BaseMsgAdapter {

    public UserImageAdapter(Context context, Fragment fragment) {
        super(context, fragment);
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_user_image");
    }

    @Override
    public boolean isForViewType(Message message, int position) {
        return message.getMsgType() == Message.TYPE_USER_IMAGE;
    }

    @Override
    public void convert(ViewHolder holder, final Message message, final int position) {
        if (message instanceof FileMessage) {
            FileMessage fileMessage = (FileMessage) message;

            Styles.loadIcon(holder.getView(getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csUserPortrait,
                    CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_user");

            holder.setVisible(getViewId("aihelp_iv_msg_retry"), false);

            if (fileMessage.getMsgStatus() == Message.TYPE_LOADING) {
                AIHelpLoadingImageView imageView = holder.getView(getViewId("aihelp_iv_holder"));
                imageView.resetStatus();
                return;
            }

            final AIHelpLoadingImageView imageView = holder.getView(getViewId("aihelp_iv_holder"));
            imageView.loadIntoImageView(mContext, fileMessage);

            if (fileMessage.getMsgStatus() == Message.STATUS_FAILURE) {
                holder.setVisible(getViewId("aihelp_iv_msg_retry"), true);
                holder.setOnClickListener(getViewId("aihelp_iv_msg_retry"), getFileRetryListener(position, message));
                return;
            }

            imageView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (imageView.isLoading()) return;
                    PreviewActivity.startAct(mFragment, PreviewInfo.get(fileMessage.getContent()));
                }
            });

        }
    }

}
