package net.aihelp.ui.adapter.cs.user;

import android.app.Activity;
import android.content.Context;
import android.view.View;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.data.model.rpa.msg.base.FileMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.ui.preview.PreviewActivity;
import net.aihelp.ui.adapter.cs.BaseMsgAdapter;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.ui.widget.AIHelpLoadingImageView;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import net.aihelp.utils.TLog;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import androidx.fragment.app.Fragment;

public class UserVideoAdapter extends BaseMsgAdapter {

    private final ExecutorService mExecutorService;

    public UserVideoAdapter(Context context, Fragment fragment) {
        super(context, fragment);
        mExecutorService = Executors.newCachedThreadPool();
    }

    @Override
    public int getItemViewLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_msg_user_video");
    }

    @Override
    public boolean isForViewType(Message message, int position) {
        return message.getMsgType() == Message.TYPE_USER_VIDEO;
    }

    @Override
    public void convert(final ViewHolder holder, final Message message, final int position) {

        if (message instanceof FileMessage) {
            FileMessage fileMessage = (FileMessage) message;

            Styles.loadIcon(holder.getView(getViewId("aihelp_iv_portrait")), CustomConfig.CustomerService.csUserPortrait,
                    CustomConfig.CustomerService.isPortraitVisible, "aihelp_svg_portrait_user");

            holder.setVisible(getViewId("aihelp_iv_msg_retry"), false);

            // if the video is just selected, it's in the uploading procedure, we should just return here.
            // After the upload process is finished, this message will be updated with a normal status,
            // then we can render the video thumbnail
            if (fileMessage.getMsgStatus() == Message.TYPE_LOADING) {
                AIHelpLoadingImageView imageView = holder.getView(getViewId("aihelp_iv_holder"));
                imageView.resetStatus();
                return;
            }

            if (fileMessage.getVideoThumbnail() != null) {
                loadUpImageView(holder, fileMessage, position);
            } else {
                if (mExecutorService != null) mExecutorService.execute(new Runnable() {
                    @Override
                    public void run() {
                        fileMessage.prepareVideoThumbnail();

                        // java.lang.IllegalArgumentException: You cannot start a load for a destroyed activity
                        if (mContext instanceof Activity && ((Activity) mContext).isFinishing()) {
                            TLog.d("You cannot start a load for a destroyed activity, interrupt current invoke.");
                            return;
                        }

                        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                loadUpImageView(holder, fileMessage, position);
                            }
                        });
                    }
                });
            }
        }

    }

    private void loadUpImageView(ViewHolder holder, final FileMessage fileMessage, final int position) {
        final AIHelpLoadingImageView imageView = holder.getView(getViewId("aihelp_iv_holder"));
        imageView.loadIntoImageView(mContext, fileMessage);

        if (fileMessage.getMsgStatus() == Message.STATUS_FAILURE) {
            holder.setVisible(getViewId("aihelp_iv_msg_retry"), true);
            holder.setOnClickListener(getViewId("aihelp_iv_msg_retry"), getFileRetryListener(position, fileMessage));
            return;
        }

        imageView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (imageView.isLoading()) return;
                PreviewActivity.startAct(mFragment, PreviewInfo.get(fileMessage.getContent()));
            }
        });
    }

}
