package net.aihelp.ui.adapter.faq;

import android.content.Context;
import android.graphics.Color;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.adapter.CommonAdapter;
import net.aihelp.core.ui.adapter.ViewHolder;
import net.aihelp.data.model.faq.FaqListEntity;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;


public class FaqAlertAdapter extends CommonAdapter<FaqListEntity> {

    private View.OnClickListener mListener;
    public FaqAlertAdapter(Context context, View.OnClickListener onClickListener) {
        super(context);
        mListener = onClickListener;
    }

    @Override
    protected int itemLayoutId() {
        return ResResolver.getLayoutId("aihelp_ada_faq_alert");
    }

    @Override
    protected void convert(ViewHolder holder, FaqListEntity faq, int position) {

        TextView textView = holder.getView(ResResolver.getViewId("aihelp_tv_faq_title"));
        int backgroundColor = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor,
                Math.min(CustomConfig.CommonSetting.upperBackgroundAlpha + 0.6, 0.8));
        textView.setBackgroundColor(backgroundColor);
        textView.setTextColor(Styles.getColor(CustomConfig.CommonSetting.textColor));

        if (!TextUtils.isEmpty(faq.getQuery())) {
            String matchedWords = faq.getQuery().toLowerCase();
            String title = faq.getTitle().toLowerCase();
            int highlightColor = Color.parseColor(CustomConfig.CommonSetting.highlightedColor);
            Spannable spannedTitle = new SpannableString(faq.getTitle());
            for (int index = TextUtils.indexOf(title, matchedWords, 0); index >= 0; index = TextUtils.indexOf(title, matchedWords, index + matchedWords.length())) {
                spannedTitle.setSpan(new ForegroundColorSpan(highlightColor), index, index + matchedWords.length(), 33);
            }
            Styles.reRenderTextView(textView, spannedTitle.toString());
        } else {
            Styles.reRenderTextView(textView, faq.getTitle());
        }

        textView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mListener != null) {
                    mListener.onClick(v);
                }
            }
        });
    }

}
