package net.aihelp.ui.cs.bottom;

import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import net.aihelp.common.CustomConfig;
import net.aihelp.common.SpKeys;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.data.attachment.IAttachmentPickerListener;
import net.aihelp.data.event.HideAttachmentMenuEvent;
import net.aihelp.data.model.rpa.step.RPAStep;
import net.aihelp.ui.cs.IServiceEventListener;
import net.aihelp.ui.wrapper.TextWatcherWrapper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SoftInputUtil;
import net.aihelp.utils.SpUtil;
import net.aihelp.utils.Styles;

import java.io.File;

import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageButton;
import androidx.fragment.app.FragmentActivity;

public abstract class BottomBaseView extends LinearLayout implements View.OnClickListener, IAttachmentPickerListener {

    protected Bundle bundle;
    protected RPAStep mStep;
    protected IServiceEventListener mListener;

    protected EditText etInput;
    protected AppCompatImageButton btnSend;

    public BottomBaseView(Context context) {
        super(context);
    }

    public BottomBaseView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public BottomBaseView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setBottomViewEventListener(Bundle bundle, RPAStep step, IServiceEventListener listener) {
        this.bundle = bundle;
        this.mStep = step;
        this.mListener = listener;
    }

    protected void prepareInputView() {
        etInput = findViewById(ResResolver.getViewId("aihelp_et_input"));
        btnSend = findViewById(ResResolver.getViewId("aihelp_btn_send"));
        if (etInput != null && btnSend != null) {
            btnSend.setOnClickListener(this);
            btnSend.setEnabled(false);

            etInput.setBackground(Styles.getDrawable(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.1f), 8));
            Styles.reRenderTextView(etInput, CustomConfig.CustomerService.csInputHint);
            etInput.addTextChangedListener(new TextWatcherWrapper() {
                @Override
                public void onTextChanged(CharSequence s, int start, int before, int count) {
                    onInputTextChanged(s.toString().trim());
                    updateSendButtonStatus(s.toString().trim());
                }
            });
            etInput.setOnFocusChangeListener(new OnFocusChangeListener() {
                @Override
                public void onFocusChange(View v, boolean hasFocus) {
                    if (hasFocus) {
                        EventBus.getDefault().post(new HideAttachmentMenuEvent());
                        SoftInputUtil.showSoftInput(getContext());
                    } else {
                        SoftInputUtil.hideSoftInput(getContext(), v);
                    }
                }
            });
            etInput.setOnEditorActionListener(new TextView.OnEditorActionListener() {
                @Override
                public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                    if (actionId == EditorInfo.IME_ACTION_DONE) {
                        etInput.clearFocus();
                        if (mListener != null) {
                            mListener.onEditTextEditDone();
                        }
                        return true;
                    }
                    return false;
                }
            });
            if (this instanceof BottomManualInputView) {
                etInput.setText(SpUtil.getInstance().getString(SpKeys.INPUT_DRAFT, ""));
            } else {
                etInput.setText("");
            }
        }
    }

    protected void onInputTextChanged(CharSequence s) {

    }

    private void updateSendButtonStatus(CharSequence s) {
        try {
            if (btnSend != null) {
                boolean isSendEnable = !TextUtils.isEmpty(s.toString().trim());
                btnSend.setEnabled(isSendEnable);
                Drawable drawable = Styles.getClickableDrawable(getContext(), "aihelp_svg_ic_send_msg",
                        Color.parseColor(isSendEnable ? CustomConfig.CommonSetting.interactElementTextColor : "#C6C9D7"),
                        isSendEnable);
                btnSend.setImageDrawable(drawable);
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
                    if (btnSend.getContext().getResources().getConfiguration().getLayoutDirection() == View.LAYOUT_DIRECTION_RTL) {
                        btnSend.setScaleX(-1); // mirror icon for right-to-left layout
                    }
                }
                Styles.scaleView(btnSend);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (etInput != null) {
            if (this instanceof BottomManualInputView) {
                SpUtil.getInstance().put(SpKeys.INPUT_DRAFT, etInput.getText().toString().trim());
            } else {
                etInput.setText("");
            }
        }
    }

    @Override
    public void onClick(View v) {

    }


    @Override
    public void onPickSuccess(File pickedFile) {

    }

    @Override
    public void onPickFailure(int errCode) {

    }

    @Override
    public void onPreviewCanceled(int attachmentType) {

    }

    @Override
    public void onPreviewConfirmed(String filePath) {

    }

}
