package net.aihelp.ui.cs.bottom;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.text.InputType;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.util.concurrent.ApiExecutor;
import net.aihelp.core.util.concurrent.ApiExecutorFactory;
import net.aihelp.data.model.faq.FaqListEntity;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.step.RPAStep;
import net.aihelp.data.model.rpa.msg.UserMessage;
import net.aihelp.data.track.statistic.StatisticTracker;
import net.aihelp.ui.cs.IServiceEventListener;
import net.aihelp.data.logic.cs.TicketStatusTracker;
import net.aihelp.data.logic.cs.predict.PredictHelper;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.DebounceHelper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SoftInputUtil;
import net.aihelp.utils.Styles;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class BottomBotInputView extends BottomBaseView implements View.OnClickListener {

    private int inputType;
    private final TextView tvHint;

    public BottomBotInputView(Context context) {
        super(context);
        View.inflate(context, ResResolver.getLayoutId("aihelp_bottom_input_for_bot"), this);
        tvHint = findViewById(ResResolver.getViewId("aihelp_tv_hint"));
        prepareInputView();
    }

    @Override
    public void onClick(View v) {
        if (etInput != null && AppInfoUtil.validateNetwork(getContext()) && v.getId() == ResResolver.getViewId("aihelp_btn_send")) {
            String input = etInput.getText().toString().trim();
            switch (inputType) {
                case InputType.TYPE_CLASS_NUMBER:
                    if (!Pattern.compile("[0-9]*").matcher(input).matches()) {
                        updateInputValidator(ResResolver.getString("aihelp_enter_number"), true);
                        return;
                    }
                    break;
                case InputType.TYPE_TEXT_VARIATION_EMAIL_ADDRESS:
                    if (!Pattern.compile("^([A-Za-z0-9_\\-.])+@([A-Za-z0-9_\\-.])+\\.([A-Za-z]{2,4})$").matcher(input).matches()) {
                        updateInputValidator(ResResolver.getString("aihelp_enter_email_address"), true);
                        return;
                    }
                    break;
            }

            if (mListener != null) {
                etInput.setText("");
                SoftInputUtil.hideSoftInput(getContext(), etInput);
                UserMessage userMessage = Message.getUserTextMsg(input);
                userMessage.setRequestParams(input, UserMessage.INPUT_FORMAT_TEXT, UserMessage.INPUT_SOURCE_INPUT);
                mListener.onUserAction(userMessage);
                StatisticTracker.getInstance().onUserInput();
            }
        }
    }

    private void updateInputValidator(String hint, boolean visible) {
        tvHint.setVisibility(visible ? VISIBLE : GONE);
        Styles.reRenderTextView(tvHint, hint, Color.parseColor("#D22121"), visible, 11);
    }

    @Override
    protected void onInputTextChanged(CharSequence s) {
        if (TicketStatusTracker.isTicketServingByAnswerBot()) {
            // it's inappropriate to do this in a view, but to simplify the fragment's logic, let's leave it alone
            if (TextUtils.isEmpty(s) || s.length() > 200) {
                DebounceHelper.INSTANCE.resetTimer();
                if (mListener != null) {
                    mListener.onPredictResult(s, new ArrayList<>());
                }
            } else {
                DebounceHelper.INSTANCE.debounceAsync(new Runnable() {
                    @Override
                    public void run() {
                        final List<FaqListEntity> faqs = PredictHelper.getPredictList(String.valueOf(s));
                        ApiExecutorFactory.getHandlerExecutor().runOnUiThread(new Runnable() {
                            @Override
                            public void run() {
                                if (mListener != null) {
                                    mListener.onPredictResult(s, faqs);
                                }
                            }
                        });
                    }
                });
            }
        }
    }

    @Override
    public void setBottomViewEventListener(Bundle bundle, RPAStep step, IServiceEventListener mListener) {
        super.setBottomViewEventListener(bundle, step, mListener);
        if (etInput != null) {
            switch (step.getNextStep()) {
                case RPAStep.STEP_BOT_INPUT_TEXT:
                    inputType = InputType.TYPE_CLASS_TEXT;
                    etInput.setHint(CustomConfig.CustomerService.csInputHint);
                    break;
                case RPAStep.STEP_BOT_INPUT_MAIL:
                    inputType = InputType.TYPE_TEXT_VARIATION_EMAIL_ADDRESS;
                    etInput.setHint(ResResolver.getString("aihelp_enter_email_address"));
                    break;
                case RPAStep.STEP_BOT_INPUT_NUMBER:
                    inputType = InputType.TYPE_CLASS_NUMBER;
                    etInput.setHint(ResResolver.getString("aihelp_enter_number"));
                    break;
            }
        }
    }

}
