package net.aihelp.ui.cs.bottom;

import android.app.DatePickerDialog;
import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.DatePicker;
import android.widget.LinearLayout;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.data.event.OrientationChangeEvent;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.msg.UserMessage;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import java.util.Calendar;

import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageButton;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;

public class BottomDatePickerView extends BottomBaseView implements View.OnClickListener {

    private LinearLayout llDatePicker;
    private TextView tvDate;
    private AppCompatImageButton btnSend;

    private DatePickerDialog pickerDialog;
    private int currentYear;
    private int currentMonth;
    private int currentDayOfMonth;

    public BottomDatePickerView(Context context) {
        this(context, null);
    }

    public BottomDatePickerView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BottomDatePickerView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View.inflate(context, ResResolver.getLayoutId("aihelp_bottom_date_picker"), this);

        llDatePicker = findViewById(ResResolver.getViewId("aihelp_ll_date"));
        tvDate = findViewById(ResResolver.getViewId("aihelp_tv_date"));
        btnSend = findViewById(ResResolver.getViewId("aihelp_btn_send"));

        llDatePicker.setBackground(Styles.getDrawable(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.1f), 8));
        llDatePicker.setOnClickListener(this);

        Styles.reRenderTextView(tvDate, ResResolver.getString("aihelp_select_date"), 0.5f);

        btnSend.setOnClickListener(this);
        btnSend.setEnabled(false);

        Calendar ca = Calendar.getInstance();
        currentYear = ca.get(Calendar.YEAR);
        currentMonth = ca.get(Calendar.MONTH);
        currentDayOfMonth = ca.get(Calendar.DAY_OF_MONTH);

    }

    @Override
    public void onClick(View v) {

        if (AppInfoUtil.validateNetwork(getContext()) && v.getId() == ResResolver.getViewId("aihelp_ll_date")) {
            showDatePicker(currentYear, currentMonth, currentDayOfMonth);
        }

        if (AppInfoUtil.validateNetwork(getContext()) && v.getId() == ResResolver.getViewId("aihelp_btn_send")) {
            if (AppInfoUtil.validateNetwork(getContext())) {
                if (mListener != null) {
                    // TODO: MD
                    String input = tvDate.getText().toString().trim();
                    UserMessage userMessage = Message.getUserTextMsg(input);
                    userMessage.setRequestParams(input, UserMessage.INPUT_FORMAT_DATE, UserMessage.INPUT_SOURCE_DATE);
                    mListener.onUserAction(userMessage);
                }
            }
        }
    }

    private void updateSendButtonStatus(CharSequence s) {
        try {
            VectorDrawableCompat drawable = VectorDrawableCompat.create(getResources(),
                    ResResolver.getDrawableId("aihelp_svg_ic_send_msg"), null);
            if (drawable != null) {
                int greyColor = Color.parseColor("#C6C9D7");
                int blueColor = Color.parseColor(CustomConfig.CommonSetting.interactElementTextColor);
                if (!TextUtils.isEmpty(s.toString().trim())) {
                    btnSend.setEnabled(true);
                    DrawableCompat.setTint(DrawableCompat.wrap(drawable).mutate(), blueColor);
                } else {
                    btnSend.setEnabled(false);
                    DrawableCompat.setTint(DrawableCompat.wrap(drawable).mutate(), greyColor);
                }
                btnSend.setImageDrawable(drawable);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        EventBus.getDefault().register(this);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        EventBus.getDefault().unregister(this);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onEventComing(OrientationChangeEvent event) {
        if (pickerDialog != null && pickerDialog.isShowing()) {
            pickerDialog.dismiss();
            showDatePicker(currentYear, currentMonth, currentDayOfMonth);
        }
    }

    private void showDatePicker(int year, int month, int day) {
        pickerDialog = new DatePickerDialog(getContext(), new DatePickerDialog.OnDateSetListener() {
            @Override
            public void onDateSet(DatePicker view, int year, int month, int dayOfMonth) {
                currentYear = year;
                currentMonth = month;
                currentDayOfMonth = dayOfMonth;
                final String data = String.format("%s%s%s", currentYear,
                        currentMonth + 1 < 10 ? "0" + (currentMonth + 1) : currentMonth + 1,
                        currentDayOfMonth < 10 ? "0" + currentDayOfMonth : currentDayOfMonth);
                Styles.reRenderTextView(tvDate, data);
                updateSendButtonStatus(data);
            }
        }, year, month, day);
        pickerDialog.show();
    }

}
