package net.aihelp.ui.cs.bottom;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;

import net.aihelp.common.IntentValues;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.msg.UserMessage;
import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;

import org.json.JSONException;
import org.json.JSONObject;

import androidx.annotation.Nullable;

public class BottomEvaluateFaqView extends BottomBaseView {

    public BottomEvaluateFaqView(Context context) {
        this(context, null);
    }

    public BottomEvaluateFaqView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BottomEvaluateFaqView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View.inflate(context, ResResolver.getLayoutId("aihelp_bottom_evaluate_faq_view"), this);

        AIHelpButton btnUnHelpful = findViewById(ResResolver.getViewId("aihelp_btn_un_helpful"));
        btnUnHelpful.setText(ResResolver.getString("aihelp_faq_unhelpful"));
        btnUnHelpful.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (AppInfoUtil.validateNetwork(getContext()) && mListener != null) {
                    String escape = btnUnHelpful.getText().toString();
                    UserMessage userMessage = Message.getUserTextMsg(escape);
                    userMessage.setRequestParams(appendContentId(UserMessage.getRequestParams(escape, false,
                            UserMessage.INPUT_FORMAT_BUTTON, "unlike", UserMessage.INPUT_SOURCE_RPA_FAQ)));
                    mListener.onUserAction(userMessage);
                }
            }
        });

        AIHelpButton btnHelpful = findViewById(ResResolver.getViewId("aihelp_btn_helpful"));
        btnHelpful.setText(ResResolver.getString("aihelp_faq_helpful"));
        btnHelpful.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (AppInfoUtil.validateNetwork(getContext()) && mListener != null) {
                    String escape = btnHelpful.getText().toString();
                    UserMessage userMessage = Message.getUserTextMsg(escape);
                    userMessage.setRequestParams(appendContentId(UserMessage.getRequestParams(escape, false,
                            UserMessage.INPUT_FORMAT_BUTTON, "like", UserMessage.INPUT_SOURCE_RPA_FAQ)));
                    mListener.onUserAction(userMessage);
                }
            }
        });

    }

    private JSONObject appendContentId(JSONObject requestParams) {
        try {
            requestParams.put("contentId", bundle.getLong(IntentValues.BOTTOM_FAQ_CONTENT_ID, 0));
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return requestParams;
    }

}
