package net.aihelp.ui.cs.bottom;

import android.content.Context;
import android.content.res.ColorStateList;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.SparseArray;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.common.UserProfile;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.core.util.bus.event.EventCenter;
import net.aihelp.data.event.OrientationChangeEvent;
import net.aihelp.data.model.rpa.msg.UserMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.step.RPAStep;
import net.aihelp.ui.cs.IServiceEventListener;
import net.aihelp.data.logic.cs.TicketStatusTracker;
import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.ui.widget.AIHelpRatingBar;
import net.aihelp.ui.widget.AIHelpScrollView;
import net.aihelp.ui.wrapper.TextWatcherWrapper;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SoftInputUtil;
import net.aihelp.utils.SpUtil;
import net.aihelp.utils.Styles;
import net.aihelp.utils.ToastUtil;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

public class BottomEvaluateServiceView extends BottomBaseView {

    private final LinearLayout llFeedbackLayout;
    private EditText etFeedback;
    private SparseArray<JSONArray> opinionArray;

    private int selectedRateValue = 5;
    private final List<String> selectedOptionIds = new ArrayList<>();
    private String inputFeedback = "";

    public BottomEvaluateServiceView(Context context) {
        super(context);

        View.inflate(context, ResResolver.getLayoutId("aihelp_bottom_evaluate_service_view"), this);

        // 主背景
        int backgroundColor = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor,
                Math.min(CustomConfig.CommonSetting.upperBackgroundAlpha + 0.6, 0.8));
        RelativeLayout rateLayout = findViewById(ResResolver.getViewId("aihelp_rl_rate_layout"));
        rateLayout.setBackgroundColor(backgroundColor);

        // Rating bar dislike text
        TextView tvRatingDislike = findViewById(ResResolver.getViewId("aihelp_tv_rating_dislike"));
        Styles.reRenderTextView(tvRatingDislike, ResResolver.getString("aihelp_rate_dissatisfied"));

        // Rating bar like text
        TextView tvRatingLike = findViewById(ResResolver.getViewId("aihelp_tv_rating_like"));
        Styles.reRenderTextView(tvRatingLike, ResResolver.getString("aihelp_rate_satisfied"));

        llFeedbackLayout = findViewById(ResResolver.getViewId("aihelp_ll_feedback"));

        AIHelpRatingBar ratingBar = findViewById(ResResolver.getViewId("aihelp_rating_bar"));
        if (ratingBar != null) {
            ratingBar.setOnStatusChangedListener(new AIHelpRatingBar.OnStatusChangedListener() {
                @Override
                public void onRateStatusChanged(int newRateValue) {
                    selectedOptionIds.clear();
                    selectedRateValue = newRateValue;
                    if (opinionArray != null) {
                        resetFeedbackOptions(getContext(), opinionArray.get(newRateValue));
                    }
                }
            });
        }

        AIHelpButton btnConfirm = findViewById(ResResolver.getViewId("aihelp_btn_confirm"));
        btnConfirm.setText(ResResolver.getString("aihelp_yes")).setFullWidth();
        btnConfirm.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mStep != null && mStep.isOptionRequired() && noOptionsSelected()) {
                    ToastUtil.INSTANCE.makeRawToast(getContext(), ResResolver.getString("aihelp_select_option"));
                    return;
                }
                if (AppInfoUtil.validateNetwork(context)) {
                    UserMessage userMessage = new UserMessage();
                    userMessage.setRequestType(UserMessage.REQUEST_TYPE_EVALUATE);
                    userMessage.setRequestParams(getRequestParams());
                    userMessage.setEvaluateGrade(selectedRateValue);
                    userMessage.setContent(String.format("%s\n%s", getSelectedOptions(), getInputFeedback()).trim());
                    userMessage.setMsgType(Message.TYPE_USER_EVALUATE_SERVICE);
                    mListener.onUserAction(userMessage);
                }
                // reset current user's unread message count to 0 after the evaluation is finished
                SpUtil.getInstance().put(UserProfile.USER_ID, 0);
                // reset all flags after the ticket is finished to make sure that after finished a ticket
                TicketStatusTracker.resetTicketStatusFlags();
            }
        });

        AIHelpScrollView scrollView = findViewById(ResResolver.getViewId("aihelp_scroll_view"));
        scrollView.updateMaxHeight();

        SoftInputUtil.hideSoftInput(getContext(), this);
    }

    @Override
    public void setBottomViewEventListener(Bundle bundle, RPAStep step, IServiceEventListener listener) {
        super.setBottomViewEventListener(bundle, step, listener);
        if (step != null) {
            opinionArray = step.getOpinionArray();
            if (opinionArray != null) {
                resetFeedbackOptions(getContext(), opinionArray.get(selectedRateValue));
            }
        }
    }

    private boolean noOptionsSelected() {
        JSONArray selectedOptions = new JSONArray();
        if (opinionArray != null) {
            JSONArray options = opinionArray.get(selectedRateValue);
            for (int i = 0; i < selectedOptionIds.size(); i++) {
                String id = selectedOptionIds.get(i);
                for (int j = 0; j < options.length(); j++) {
                    JSONObject object = JsonHelper.getJsonObject(options, j);
                    if (id.equals(JsonHelper.optString(object, "id"))) {
                        selectedOptions.put(object);
                    }
                }
            }
            return options.length() > 0 && selectedOptions.length() == 0;
        }
        return false;
    }

    private String getInputFeedback() {
        String input = "";
        if (etFeedback != null) {
            input = etFeedback.getText().toString();
        }
        return input;
    }

    private String getSelectedOptions() {
        StringBuilder selectedOptions = new StringBuilder();
        if (opinionArray != null) {
            JSONArray options = opinionArray.get(selectedRateValue);
            for (int i = 0; i < selectedOptionIds.size(); i++) {
                String id = selectedOptionIds.get(i);
                for (int j = 0; j < options.length(); j++) {
                    JSONObject object = JsonHelper.getJsonObject(options, j);
                    if (id.equals(JsonHelper.optString(object, "id"))) {
                        selectedOptions.append(JsonHelper.optString(object, "value"));
                        if (i != selectedOptionIds.size() - 1) {
                            selectedOptions.append(",");
                        }
                    }
                }
            }
        }
        return selectedOptions.toString();
    }

    private JSONObject getRequestParams() {
        JSONArray selectedOptions = new JSONArray();
        if (opinionArray != null) {
            JSONArray options = opinionArray.get(selectedRateValue);
            for (int i = 0; i < selectedOptionIds.size(); i++) {
                String id = selectedOptionIds.get(i);
                for (int j = 0; j < options.length(); j++) {
                    JSONObject object = JsonHelper.getJsonObject(options, j);
                    if (id.equals(JsonHelper.optString(object, "id"))) {
                        String value = JsonHelper.optString(object, "value");
                        JSONObject optionObject = JsonHelper.getJsonObject();
                        JsonHelper.put(optionObject, "id", Integer.parseInt(id));
                        JsonHelper.put(optionObject, "msg", value);
                        selectedOptions.put(optionObject);
                    }
                }
            }
        }
        JSONObject evaluateParams = new JSONObject();
        JsonHelper.put(evaluateParams, "starIndex", selectedRateValue);
        JsonHelper.put(evaluateParams, "elseMsg", getInputFeedback());
        JsonHelper.put(evaluateParams, "chooseList", selectedOptions);
        JsonHelper.put(evaluateParams, "userId", UserProfile.USER_ID);
        return evaluateParams;
    }

    private void resetFeedbackOptions(Context context, JSONArray options) {
        AIHelpScrollView scrollView = findViewById(ResResolver.getViewId("aihelp_scroll_view"));
        scrollView.updateMaxHeight();
        if (Styles.isLandscape()) {
            prepareFeedbackForLandscape(context, options);
        } else {
            prepareFeedbackForPortrait(context, options);
        }
    }

    private void prepareFeedbackForPortrait(Context context, JSONArray options) {
        llFeedbackLayout.removeAllViews();
        if (options != null && options.length() > 0) {
            for (int i = 0; i < options.length(); i++) {
                llFeedbackLayout.addView(getFeedbackOptionItem(context, JsonHelper.getJsonObject(options, i)));
            }
            prepareFeedbackInput(context);
        }
    }

    private void prepareFeedbackForLandscape(Context context, JSONArray options) {
        llFeedbackLayout.removeAllViews();
        if (options != null && options.length() > 0) {
            for (int i = 0; i < options.length(); i += 2) {
                View previousView = getFeedbackOptionItem(context, JsonHelper.getJsonObject(options, i));
                View afterwardsView = null;
                if (i + 1 < options.length()) {
                    afterwardsView = getFeedbackOptionItem(context, JsonHelper.getJsonObject(options, i + 1));
                }

                LinearLayout linearLayout = new LinearLayout(context);
                linearLayout.setOrientation(LinearLayout.HORIZONTAL);
                linearLayout.addView(previousView);
                if (afterwardsView != null) {
                    linearLayout.addView(afterwardsView);
                }
                llFeedbackLayout.addView(linearLayout);
            }
            prepareFeedbackInput(context);
        }
    }

    private void prepareFeedbackInput(Context context) {
        View view = View.inflate(context, ResResolver.getLayoutId("aihelp_layout_feedback_input"), null);
        view.setBackground(Styles.getDrawable(Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.1f), 8));
        ViewGroup.MarginLayoutParams marginLayoutParams = new ViewGroup.MarginLayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        marginLayoutParams.topMargin = Styles.dpToPx(context, 10);
        view.setLayoutParams(marginLayoutParams);

        etFeedback = view.findViewById(ResResolver.getViewId("aihelp_et_feedback_input"));
        Styles.reRenderTextView(etFeedback, ResResolver.getString("aihelp_rate_additional_feedback_message"));
        etFeedback.setGravity(Styles.isLayoutRtl(this) ? Gravity.END : Gravity.START);

        TextView tvMaxLength = view.findViewById(ResResolver.getViewId("aihelp_tv_max_length"));
        Styles.reRenderTextView(tvMaxLength, "0/500", Styles.getColor(CustomConfig.CommonSetting.textColor));
        etFeedback.addTextChangedListener(new TextWatcherWrapper() {
            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                tvMaxLength.setText(String.format("%s/%s", s.length(), 500));
            }
        });
        etFeedback.setMaxHeight(Styles.dpToPx(context, 120));

        if (!TextUtils.isEmpty(inputFeedback)) {
            etFeedback.setText(inputFeedback);
        }

        llFeedbackLayout.addView(view);
    }

    /**
     * 横屏下：选项分为两列显示 + 最后一个输入框，竖屏下：选项单列显示 + 最后一个输入框
     */
    private View getFeedbackOptionItem(Context context, JSONObject opinion) {
        CheckBox checkBox = (CheckBox) View.inflate(context, ResResolver.getLayoutId("aihelp_layout_feedback_option"), null);

        String id = JsonHelper.optString(opinion, "id");
        String value = JsonHelper.optString(opinion, "value");
        Styles.reRenderTextView(checkBox, value);

        // 在设置监听之前设置勾选（可能是因为屏幕旋转出现的），否则会导致数据重复
        for (int i = 0; i < selectedOptionIds.size(); i++) {
            if (id.equals(selectedOptionIds.get(i))) {
                checkBox.setChecked(true);
                break;
            }
        }

        checkBox.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener() {
            @Override
            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                if (isChecked) {
                    selectedOptionIds.add(JsonHelper.optString(opinion, "id"));
                } else {
                    selectedOptionIds.remove(JsonHelper.optString(opinion, "id"));
                }
                updateCheckBoxEnableStatus(context);
            }
        });

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            ColorStateList colorStateList = new ColorStateList(
                    new int[][]{new int[]{-android.R.attr.state_checked}, new int[]{android.R.attr.state_checked}},
                    new int[]{Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.1f),
                            Styles.getColor(CustomConfig.CommonSetting.interactElementTextColor)}
            );
            checkBox.setButtonTintList(colorStateList);
        }

        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        params.weight = 1;
        checkBox.setLayoutParams(params);

        return checkBox;
    }

    private void updateCheckBoxEnableStatus(Context context) {
        int childCount = llFeedbackLayout.getChildCount();
        if (Styles.isLandscape()) {
            for (int i = 0; i < childCount; i++) {
                View childView = llFeedbackLayout.getChildAt(i);
                if (childView instanceof LinearLayout) {
                    LinearLayout layout = (LinearLayout) childView;
                    for (int j = 0; j < layout.getChildCount(); j++) {
                        View view = layout.getChildAt(j);
                        if (view instanceof CheckBox) {
                            CheckBox checkBox = (CheckBox) view;
                            if (!checkBox.isChecked() && mStep != null) {
                                checkBox.setEnabled(selectedOptionIds.size() < mStep.getMaxOptionCount());
                            }
                        }
                    }
                }
            }
        } else {
            for (int i = 0; i < childCount; i++) {
                View childView = llFeedbackLayout.getChildAt(i);
                if (childView instanceof CheckBox) {
                    CheckBox checkBox = (CheckBox) childView;
                    if (!checkBox.isChecked() && mStep != null) {
                        checkBox.setEnabled(selectedOptionIds.size() < mStep.getMaxOptionCount());
                    }
                }
            }
        }

    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        EventBus.getDefault().register(this);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        EventBus.getDefault().unregister(this);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onEventComing(EventCenter<?> event) {
        if (event instanceof OrientationChangeEvent && etFeedback != null) {
            inputFeedback = etFeedback.getText().toString();
            if (opinionArray != null) {
                resetFeedbackOptions(etFeedback.getContext(), opinionArray.get(selectedRateValue));
            }
        }
    }

}
