package net.aihelp.ui.cs.bottom;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;

import net.aihelp.common.IntentValues;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.data.event.PageHoppingEvent;
import net.aihelp.data.model.rpa.step.RPAStep;
import net.aihelp.data.track.statistic.StatisticTracker;
import net.aihelp.ui.cs.IServiceEventListener;
import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;

public class BottomFillFormView extends BottomBaseView implements View.OnClickListener {

    public BottomFillFormView(Context context) {
        super(context);
        View.inflate(context, ResResolver.getLayoutId("aihelp_bottom_fill_form"), this);

        AIHelpButton btGoFill = findViewById(ResResolver.getViewId("aihelp_btn_go_fill"));
        btGoFill.setText(ResResolver.getString("aihelp_fill_in"));
        btGoFill.setOnClickListener(this);
    }

    @Override
    public void setBottomViewEventListener(Bundle bundle, RPAStep step, IServiceEventListener listener) {
        super.setBottomViewEventListener(bundle, step, listener);
        if (!TextUtils.isEmpty(step.getFormButtonHint())) {
            AIHelpButton btGoFill = findViewById(ResResolver.getViewId("aihelp_btn_go_fill"));
            btGoFill.setText(step.getFormButtonHint());
        }
    }

    @Override
    public void onClick(View v) {
        if (AppInfoUtil.validateNetwork(getContext()) && v.getId() == ResResolver.getViewId("aihelp_btn_go_fill")) {
            EventBus.getDefault().post(new PageHoppingEvent(IntentValues.PAGE_HOPPING_FORM, bundle));
            String formUrl = bundle.getString(IntentValues.INTENT_URL, "");
            StatisticTracker.getInstance().onFormClicked(formUrl);
        }
    }

}
