package net.aihelp.ui.cs.bottom;

import android.Manifest;
import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.common.IntentValues;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.core.util.bus.event.EventCenter;
import net.aihelp.core.util.permission.AIHelpPermissions;
import net.aihelp.core.util.permission.IPermissionCallback;
import net.aihelp.core.util.permission.Permission;
import net.aihelp.data.attachment.IAttachmentPickerListener;
import net.aihelp.data.event.HideAttachmentMenuEvent;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.msg.UserMessage;
import net.aihelp.data.attachment.AttachmentPicker;
import net.aihelp.ui.widget.snackbar.Snackbar;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.KeyboardChangeHelper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.SoftInputUtil;
import net.aihelp.utils.Styles;
import net.aihelp.utils.ToastUtil;

import java.io.File;

import androidx.fragment.app.Fragment;

public class BottomManualInputView extends BottomAttachmentView implements View.OnClickListener, IAttachmentPickerListener {

    private final ImageView ivAttach;

    private final View vToolsLayout;
    private final int toolHeight;
    private final LinearLayout llToolContainer;

    public BottomManualInputView(Context context) {
        super(context);
        removeAllViews(); // 移除继承自 BottomAttachmentView 的布局样式，添加自己的样式

        View.inflate(context, ResResolver.getLayoutId("aihelp_bottom_input_for_manual"), this);

        ivAttach = findViewById(ResResolver.getViewId("aihelp_iv_attach"));
        ivAttach.setOnClickListener(this);
        Styles.reRenderImageView(ivAttach, "aihelp_svg_ic_add_attachment", true);

        vToolsLayout = findViewById(ResResolver.getViewId("aihelp_rl_tool"));

        View vDivider = findViewById(ResResolver.getViewId("aihelp_v_divider"));
        int upperBackgroundColor = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor,
                CustomConfig.CommonSetting.upperBackgroundAlpha);
        int iconBgColor = Styles.getColorWithAlpha(Styles.isLightColor(upperBackgroundColor) ? Color.BLACK : Color.WHITE, 0.1);
        vDivider.setBackgroundColor(iconBgColor);

        llToolContainer = findViewById(ResResolver.getViewId("aihelp_ll_tool_item"));
        if (CustomConfig.UploadLimit.isImageEnableUploading || CustomConfig.UploadLimit.isVideoEnableUploading) {
            llToolContainer.addView(getToolItemView(AttachmentPicker.ATTACHMENT_TYPE_MEDIA));
        }
        if (CustomConfig.UploadLimit.isFileEnableUploading) {
            llToolContainer.addView(getToolItemView(AttachmentPicker.ATTACHMENT_TYPE_FILE));
        }

        llToolContainer.measure(0, 0);
        toolHeight = llToolContainer.getMeasuredHeight();

        prepareInputView();

        boolean enableAttach = CustomConfig.UploadLimit.isImageEnableUploading ||
                CustomConfig.UploadLimit.isVideoEnableUploading || CustomConfig.UploadLimit.isFileEnableUploading;
        ivAttach.setVisibility(enableAttach ? View.VISIBLE : View.GONE);
        ViewGroup.MarginLayoutParams layoutParams = (MarginLayoutParams) etInput.getLayoutParams();
        layoutParams.leftMargin = Styles.dpToPx(context, enableAttach ? 0 : 15);
        etInput.setLayoutParams(layoutParams);
    }

    @Override
    public void onClick(View v) {
        super.onClick(v);
        if (AppInfoUtil.validateNetwork(getContext()) && v.getId() == ResResolver.getViewId("aihelp_btn_send")) {
            if (mListener != null) {
                String input = etInput.getText().toString().trim();
                UserMessage userMessage = Message.getUserTextMsg(input);
                userMessage.setDuringRPAProcedure(false);
                userMessage.setRequestParams(input, UserMessage.INPUT_FORMAT_TEXT, UserMessage.INPUT_SOURCE_INPUT);
                mListener.onUserAction(userMessage);
                etInput.setText("");
            }
        }

        if (AppInfoUtil.validateNetwork(getContext()) && v.getId() == ResResolver.getViewId("aihelp_iv_attach")) {
            if (vToolsLayout.getHeight() == 0) {
                SoftInputUtil.hideSoftInput(getContext(), this);
                toggleToolMenu(true);
            } else {
                etInput.requestFocus();
                SoftInputUtil.showSoftInput(getContext());
                toggleToolMenu(false);
            }
        }
    }

    private void toggleToolMenu(boolean show) {
        ValueAnimator valueAnimator = ValueAnimator.ofInt(show ? new int[]{0, toolHeight} : new int[]{toolHeight, 0});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
            @Override
            public void onAnimationUpdate(ValueAnimator animation) {
                int value = (int) animation.getAnimatedValue();
                if (mListener != null) {
                    mListener.scrollBy(value);
                }
                ViewGroup.LayoutParams layoutParams = vToolsLayout.getLayoutParams();
                layoutParams.height = value;
                vToolsLayout.setLayoutParams(layoutParams);
            }
        });
        valueAnimator.addListener(new AnimatorListenerAdapter() {
            @Override
            public void onAnimationEnd(Animator animation) {
                if (!KeyboardChangeHelper.isKeyboardShown(BottomManualInputView.this)) {
                    etInput.clearFocus();
                }
                if (show && mListener != null) {
                    mListener.scrollToBottom();
                }
            }
        });
        valueAnimator.setDuration(250);
        valueAnimator.start();
    }

    @Override
    public void onPickSuccess(File pickedFile) {
        if (bundle != null && bundle.getBoolean(IntentValues.BOTTOM_TICKET_FINISHED)) {
            return;
        }
        super.onPickSuccess(pickedFile);
    }

    private View getToolItemView(int attachmentType) {
        String iconResource = "", toolName = "";
        int imgWidth = 0, imgHeight = 0;
        switch (attachmentType) {
            case AttachmentPicker.ATTACHMENT_TYPE_MEDIA:
                iconResource = "aihelp_svg_ic_image";
                toolName = ResResolver.getString("aihelp_albums");
                imgWidth = Styles.dpToPx(getContext(), 30);
                imgHeight = Styles.dpToPx(getContext(), 25);
                break;
            case AttachmentPicker.ATTACHMENT_TYPE_FILE:
                iconResource = "aihelp_svg_ic_file";
                toolName = ResResolver.getString("aihelp_file");
                imgWidth = Styles.dpToPx(getContext(), 25);
                imgHeight = Styles.dpToPx(getContext(), 30);
                break;
        }

        View itemView = View.inflate(getContext(), ResResolver.getLayoutId("aihelp_tool_item_view"), null);
        itemView.setBackground(Styles.getClickableDrawableForList());
        itemView.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (mListener != null) {
                    Fragment hostFragment = mListener.getHostFragment();
                    if (hostFragment != null) {
                        String[] permissionArray = new String[]{Manifest.permission.READ_EXTERNAL_STORAGE};
                        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
                            permissionArray = new String[]{
                                    Manifest.permission.READ_MEDIA_IMAGES,
                                    Manifest.permission.READ_MEDIA_VIDEO
                            };
                        }
                        AIHelpPermissions.getInstance()
                                .setFragment(hostFragment)
                                .setPermissionHandler(BottomManualInputView.this)
                                .setRequestCode(Permission.REQUEST_CODE_CUSTOMER_SERVICE)
                                .setRequestPermission(permissionArray)
                                .request(getContext(), attachmentType);
                    }
                }
            }
        });

        LinearLayout iconContainer = itemView.findViewById(ResResolver.getViewId("aihelp_ll_icon_container"));
        int upperBackgroundColor = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor,
                CustomConfig.CommonSetting.upperBackgroundAlpha);
        int iconBgColor = Styles.getColorWithAlpha(Styles.isLightColor(upperBackgroundColor) ? Color.BLACK : Color.WHITE, 0.1);
        iconContainer.setBackground(Styles.getDrawable(iconBgColor, 10));

        ImageView ivIcon = itemView.findViewById(ResResolver.getViewId("aihelp_iv_tool_icon"));
        ivIcon.setLayoutParams(new LinearLayout.LayoutParams(imgWidth, imgHeight));
        Styles.reRenderImageView(ivIcon, iconResource);

        TextView tvTitle = itemView.findViewById(ResResolver.getViewId("aihelp_tv_title"));
        Styles.reRenderTextView(tvTitle, toolName, Color.parseColor(CustomConfig.CommonSetting.textColor), true, 13);

        return itemView;
    }

    // region - 处理键盘弹出收起相关业务
    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        EventBus.getDefault().register(this);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        EventBus.getDefault().unregister(this);
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onEventComing(EventCenter event) {
        if (event instanceof HideAttachmentMenuEvent) {
            if (vToolsLayout.getHeight() != 0) {
                toggleToolMenu(false);
            }
        }
    }
    // endregion

}
