package net.aihelp.ui.cs.bottom;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;

import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;

import androidx.annotation.Nullable;

public class BottomNewConversationView extends BottomBaseView {

    public BottomNewConversationView(Context context) {
        this(context, null);
    }

    public BottomNewConversationView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BottomNewConversationView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View.inflate(context, ResResolver.getLayoutId("aihelp_bottom_new_conversation"), this);

        AIHelpButton tvNewConversation = findViewById(ResResolver.getViewId("aihelp_btn_new_conversation"));
        tvNewConversation.setText(ResResolver.getString("aihelp_new_conversation"));
        tvNewConversation.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (AppInfoUtil.validateNetwork(getContext()) && mListener != null) {
                    mListener.onNewConversationStarted();
                }
            }
        });

    }

}
