package net.aihelp.ui.cs.bottom;

import android.content.Context;
import android.os.Bundle;
import android.view.View;

import net.aihelp.common.UserProfile;
import net.aihelp.core.net.json.JsonHelper;
import net.aihelp.data.model.rpa.msg.UserMessage;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.step.RPAStep;
import net.aihelp.ui.cs.IServiceEventListener;
import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.DeviceUuidFactory;
import net.aihelp.utils.ResResolver;

import org.json.JSONObject;

import java.util.List;

public class BottomResolveConfirmView extends BottomBaseView {

    private final AIHelpButton resolutionNo;
    private final AIHelpButton resolutionYes;

    public BottomResolveConfirmView(Context context) {
        super(context);

        View.inflate(context, ResResolver.getLayoutId("aihelp_bottom_resolve_confirm_view"), this);

        resolutionNo = findViewById(ResResolver.getViewId("aihelp_resolution_no"));
        resolutionNo.setText(ResResolver.getString("aihelp_resolution_no"));
        resolutionNo.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (AppInfoUtil.validateNetwork(getContext()) && mListener != null) {
                    String text = resolutionNo.getText();
                    UserMessage userMessage = Message.getUserTextMsg(text);
                    userMessage.setRequestType(UserMessage.REQUEST_TYPE_RESOLUTION);
                    userMessage.setRequestParams(getRequestParams(context, false, text));
                    mListener.onUserAction(userMessage);
                }
            }
        });

        resolutionYes = findViewById(ResResolver.getViewId("aihelp_resolution_yes"));
        resolutionYes.setText(ResResolver.getString("aihelp_resolution_yes"));
        resolutionYes.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (AppInfoUtil.validateNetwork(getContext()) && mListener != null) {
                    String text = resolutionYes.getText();
                    UserMessage userMessage = Message.getUserTextMsg(text);
                    userMessage.setRequestType(UserMessage.REQUEST_TYPE_RESOLUTION);
                    userMessage.setRequestParams(getRequestParams(context, true, text));
                    mListener.onUserAction(userMessage);
                }
            }
        });
    }

    private JSONObject getRequestParams(Context context, boolean isResolved, String resolveMsg) {
        JSONObject params = JsonHelper.getJsonObject();
        JsonHelper.put(params, "userId", UserProfile.USER_ID);
        JsonHelper.put(params, "deviceId", DeviceUuidFactory.id(context));
        JsonHelper.put(params, "resolveType", isResolved ? 1 : 2);
        JsonHelper.put(params, "resolveMsg", resolveMsg);
        return params;
    }

    @Override
    public void setBottomViewEventListener(Bundle bundle, RPAStep step, IServiceEventListener mListener) {
        super.setBottomViewEventListener(bundle, step, mListener);

        if (step.getActionList() != null && step.getActionList().size() >= 2) {
            List<RPAStep.Action> actionList = step.getActionList();
            if (resolutionYes != null && resolutionNo != null) {
                RPAStep.Action firstAction = actionList.get(0);
                if (firstAction != null) {
                    resolutionYes.setText(firstAction.getContent());
                }
                RPAStep.Action secondAction = actionList.get(1);
                if (secondAction != null) {
                    resolutionNo.setText(secondAction.getContent());
                }
            }
        }
    }

}
