package net.aihelp.ui.cs.bottom;

import android.content.Context;
import android.os.Parcelable;
import android.view.View;

import net.aihelp.common.IntentValues;
import net.aihelp.data.model.rpa.msg.base.Message;
import net.aihelp.data.model.rpa.msg.bot.SelfService;
import net.aihelp.ui.cs.viewer.SelfServiceViewer;
import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;

public class BottomSelfServiceView extends BottomBaseView implements View.OnClickListener {

    private SelfServiceViewer selfServiceViewer;

    public BottomSelfServiceView(Context context) {
        super(context);
        View.inflate(context, ResResolver.getLayoutId("aihelp_bottom_self_service"), this);

        AIHelpButton btnCheckService = findViewById(ResResolver.getViewId("aihelp_btn_check_service"));
        btnCheckService.setText(ResResolver.getString("aihelp_view_details"));
        btnCheckService.setOnClickListener(this);

    }

    @Override
    public void onClick(View v) {
        super.onClick(v);
        if (AppInfoUtil.validateNetwork(getContext()) && v.getId() == ResResolver.getViewId("aihelp_btn_check_service")) {
            Parcelable parcelable = bundle.getParcelable(IntentValues.BOTTOM_SELF_SERVICE);
            if (parcelable instanceof SelfService) {
                SelfService selfService = (SelfService) parcelable;
                if (selfService.isEnableSend()) {
                    selfServiceViewer = new SelfServiceViewer();
                    selfServiceViewer.getService(getContext(), bundle.getParcelable(IntentValues.BOTTOM_SELF_SERVICE));
                    selfServiceViewer.setOnSelfServiceConfirmListener(new SelfServiceViewer.OnSelfServiceConfirmListener() {
                        @Override
                        public void onSelected(Message message) {
                            if (AppInfoUtil.validateNetwork(getContext()) && mListener != null) {
                                mListener.onUserAction(message);
                            }
                        }
                    });
                }
            }
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (selfServiceViewer != null) {
            selfServiceViewer.setOnSelfServiceConfirmListener(null);
        }
    }
}
