package net.aihelp.ui.cs.middle.predict;

import android.content.Context;
import android.util.AttributeSet;

import net.aihelp.utils.Styles;

import androidx.recyclerview.widget.RecyclerView;

public class PredictRecyclerView extends RecyclerView {

    public PredictRecyclerView(Context context) {
        this(context, null);
    }

    public PredictRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PredictRecyclerView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {

        float factor = Styles.isLandscape() ? 0.8f : 0.7f;
        // 150dp = StatusBar(10dp) + NavigationBar(44dp) + MiddleHandlerView(20dp) + BottomView(54dp) + LogoView(10dp) + Padding
        int maxHeight = (int) (factor * (Styles.getScreenHeight(getContext()) - Styles.dpToPx(getContext(), 150)));
        maxHeight = Math.min(maxHeight, Styles.dpToPx(getContext(), 40 * 3f));

        heightMeasureSpec = MeasureSpec.makeMeasureSpec(maxHeight, MeasureSpec.AT_MOST);
        widthMeasureSpec = MeasureSpec.makeMeasureSpec(Styles.getScreenWidth(getContext()), MeasureSpec.EXACTLY);

        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    @Override
    public void setVisibility(int visibility) {
        super.setVisibility(visibility);
        scrollToPosition(0);
    }
}
