package net.aihelp.ui.cs.viewer;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Color;
import android.os.Build;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import net.aihelp.BuildConfig;
import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.dialog.AlertDialog;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.Subscribe;
import net.aihelp.core.util.bus.ThreadMode;
import net.aihelp.data.event.OrientationChangeEvent;
import net.aihelp.data.localize.config.ProcessEntranceHelper;
import net.aihelp.data.model.rpa.msg.BotMessage;
import net.aihelp.data.model.rpa.msg.bot.Faq;
import net.aihelp.ui.helper.WebViewInjector;
import net.aihelp.ui.webkit.AIHelpWebProgress;
import net.aihelp.ui.webkit.AIHelpWebView;
import net.aihelp.ui.webkit.AIHelpWebViewClient;
import net.aihelp.ui.widget.AIHelpEvaluateButtonView;
import net.aihelp.utils.DomainSupportHelper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import net.aihelp.utils.TLog;

import org.json.JSONObject;

public enum BotFaqViewer implements View.OnClickListener {

    INSTANCE;

    private AlertDialog faqAlertDialog = null;
    private AIHelpWebView mWebView = null;

    public void show(Context context, BotMessage botMessage, Faq.FaqData faq, OnFaqEvaluateListener evaluateListener) {

        String url = DomainSupportHelper.getAdjustedUrl(faq.getFaqContent());
        if (!url.contains("isCustom=1")) url = url + "&isCustom=1";
        url = url + String.format("&sdkVersion=%s&templateId=%s",
                BuildConfig.SDK_VERSION,
                ProcessEntranceHelper.INSTANCE.getCurrentProcess().getTemplateId());

        faqAlertDialog = new AlertDialog.Builder(context)
                .setContentView(ResResolver.getLayoutId("aihelp_dia_elva_faq"))
                .setGravity(Gravity.BOTTOM)
                .fromBottom(true)
                .setCancelableOntheOutside(true)
                .setOnDismissListener(new DialogInterface.OnDismissListener() {
                    @Override
                    public void onDismiss(DialogInterface dialog) {
                        if (EventBus.getDefault().isRegistered(this)) {
                            EventBus.getDefault().unregister(BotFaqViewer.this);
                        }
                    }
                })
                .setWidthAndHeight(ViewGroup.LayoutParams.MATCH_PARENT, 500)
                .setHeightByDevice()
                .create();

        RelativeLayout rootLayout = faqAlertDialog.findViewById(ResResolver.getViewId("aihelp_rl_root"));
        rootLayout.setBackgroundColor(Styles.getColor(CustomConfig.CommonSetting.upperBackgroundColor));

        final ImageView ivBack = faqAlertDialog.findViewById(ResResolver.getViewId("aihelp_iv_back"));
        ivBack.setOnClickListener(this);
        Styles.reRenderImageView(ivBack, "aihelp_svg_ic_back");

        final ImageView ivClose = faqAlertDialog.findViewById(ResResolver.getViewId("aihelp_iv_close"));
        ivClose.setOnClickListener(this);
        Styles.reRenderImageView(ivClose, "aihelp_svg_ic_close_dialog");

        mWebView = faqAlertDialog.findViewById(ResResolver.getViewId("aihelp_web_view"));
        mWebView.setBackgroundColor(Color.TRANSPARENT);

        AIHelpWebProgress progressBar = faqAlertDialog.findViewById(ResResolver.getViewId("aihelp_progress_bar"));

        AIHelpWebViewClient webViewClient = new AIHelpWebViewClient(context, progressBar);
        webViewClient.setUrlLoadingListener(new AIHelpWebViewClient.ShouldOverrideUrlLoadingListener() {
            @Override
            public void handleUrlClick(boolean result) {
                ivBack.setVisibility(View.VISIBLE);
            }
        });
        mWebView.setWebViewClient(webViewClient);
        WebViewInjector.getInstance().setContext(context).inject(mWebView, webViewClient);

        mWebView.setWebChromeClient(new WebChromeClient() {
            boolean isFinishedAlready;

            @Override
            public void onProgressChanged(WebView view, int newProgress) {
                super.onProgressChanged(view, newProgress);
                progressBar.setProgress(newProgress);
                if (newProgress == 100 && !isFinishedAlready) {
                    view.postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            if (faq.getFaqSource() == Faq.FAQ_SOURCE_ANSWER_BOT) {
                                prepareEvaluateButtonView(botMessage, faq, evaluateListener);
                            }
                        }
                    }, 500);
                    isFinishedAlready = true;
                }
            }
        });

        if (!EventBus.getDefault().isRegistered(this)) {
            EventBus.getDefault().register(this);
        }

        mWebView.loadUrl(url);
        faqAlertDialog.show();

        TLog.d("BotFaq: " + url);

    }

    private void prepareEvaluateButtonView(BotMessage botMessage, Faq.FaqData faq, OnFaqEvaluateListener evaluateListener) {
        AIHelpEvaluateButtonView evaluateButtonView = faqAlertDialog.findViewById(ResResolver.getViewId("aihelp_evaluate_view"));
        evaluateButtonView.refreshViewState(botMessage.getUserFeedback());
        evaluateButtonView.setOnAIHelpEvaluateViewCallback(new AIHelpEvaluateButtonView.OnAIHelpEvaluateViewCallback() {
            @Override
            public void onEvaluated(boolean isHelpful) {
                botMessage.setUserFeedback(isHelpful ? BotMessage.USER_FEEDBACK_POSITIVE : BotMessage.USER_FEEDBACK_NEGATIVE);
                if (evaluateListener != null) {
                    evaluateListener.onEvaluated(botMessage, isHelpful);
                }
            }

            @Override
            public JSONObject requestDataForFeedback() {
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("mainId", faq.getMainId());
                    jsonObject.put("contentId", faq.getContentId());
                    jsonObject.put("isClickDetail", faq.isFaqViewed());
                    jsonObject.put("pointMessageId", String.valueOf(botMessage.getTimestamp()));
                } catch (Exception e) {
                    // ignored
                }
                return jsonObject;
            }
        });
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == ResResolver.getViewId("aihelp_iv_close")) {
            if (faqAlertDialog != null) faqAlertDialog.dismiss();
        }

        if (v.getId() == ResResolver.getViewId("aihelp_iv_back")) {
            if (mWebView != null && mWebView.canGoBack()) {
                mWebView.goBack();
                if (!mWebView.canGoBack()) {
                    v.setVisibility(View.GONE);
                }
            }
        }
    }

    @Subscribe(threadMode = ThreadMode.MAIN)
    public void onEventComing(OrientationChangeEvent event) {
        if (faqAlertDialog != null && faqAlertDialog.isShowing()) {
            faqAlertDialog.dismiss();
        }
    }

    public interface OnFaqEvaluateListener {
        void onEvaluated(BotMessage botMessage, boolean isHelpful);
    }
}
