package net.aihelp.ui.cs.viewer;

import android.content.Context;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

import net.aihelp.common.CustomConfig;
import net.aihelp.core.ui.dialog.AlertDialog;
import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

public class InviteRateAppHelper {

    public static void showThanks(final Context context, boolean rateApp) {
        AlertDialog showThanksDialog = new AlertDialog.Builder(context)
                .setContentView(ResResolver.getLayoutId("aihelp_dia_show_thanks"))
                .setGravity(Gravity.BOTTOM)
                .fromBottom(true)
                .setCancelableOntheOutside(true)
                .setWidthAndHeight(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
                .create();

        View rlShowThanks = showThanksDialog.getView(ResResolver.getViewId("aihelp_rl_show_thanks"));
        int backgroundColor = Styles.getColorWithAlpha(CustomConfig.CommonSetting.upperBackgroundColor,
                Math.min(CustomConfig.CommonSetting.upperBackgroundAlpha + 0.6f, 0.8f));
        rlShowThanks.setBackgroundColor(backgroundColor);

        TextView tvTitle = showThanksDialog.getView(ResResolver.getViewId("aihelp_tv_thanks"));
        Styles.reRenderTextView(tvTitle, ResResolver.getString("aihelp_rate_finished"));

        TextView tvCancel = showThanksDialog.getView(ResResolver.getViewId("aihelp_tv_invite_rate"));
        Styles.reRenderTextView(tvCancel, ResResolver.getString("aihelp_rate_app_hint"),
                Styles.getColorWithAlpha(CustomConfig.CommonSetting.textColor, 0.5f));

        AIHelpButton tvRate = showThanksDialog.getView(ResResolver.getViewId("aihelp_go_rate"));
        tvRate.setText(ResResolver.getString("aihelp_rate_button"));
        tvRate.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                AppInfoUtil.goRateApp(context);
                showThanksDialog.dismiss();
            }
        });

        View goRateLayout = showThanksDialog.getView(ResResolver.getViewId("aihelp_ll_go_rate"));
        goRateLayout.setVisibility(rateApp ? View.VISIBLE : View.GONE);

        showThanksDialog.show();
    }

}
