package net.aihelp.ui.faq;

import android.graphics.Color;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.ViewFlipper;

import net.aihelp.common.CustomConfig;
import net.aihelp.common.IntentValues;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.bus.event.EventCenter;
import net.aihelp.data.event.NetErrorEvent;
import net.aihelp.data.event.OrientationChangeEvent;
import net.aihelp.data.localize.data.FaqHelper;
import net.aihelp.data.track.event.EventTracker;
import net.aihelp.data.track.event.utils.EventType;
import net.aihelp.data.logic.faq.FaqPresenter;
import net.aihelp.data.model.faq.FaqListEntity;
import net.aihelp.data.track.statistic.StatisticTracker;
import net.aihelp.ui.adapter.faq.FaqCardLayoutAdapter;
import net.aihelp.ui.widget.AIHelpFaqCardLayout;
import net.aihelp.ui.wrapper.FaqSelectedListenerWrapper;
import net.aihelp.utils.ListUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;

import java.util.List;

public class FaqHomeFragment extends BaseFaqFragment<FaqPresenter> {

    private LinearLayout llRootLayout;
    LinearLayout llNotification;
    AIHelpFaqCardLayout rvHotTopics;
    AIHelpFaqCardLayout rvCommonQuestions;

    private boolean isNotificationEmpty = true;
    private boolean isHotTopicsEmpty = true;
    private boolean isSectionsEmpty = true;

    public static FaqHomeFragment newInstance(Bundle bundle) {
        FaqHomeFragment faqFragment = new FaqHomeFragment();
        faqFragment.setArguments(bundle);
        return faqFragment;
    }

    @Override
    protected void getBundleBeforeDataPrepared(Bundle extras) {
        super.getBundleBeforeDataPrepared(extras);
    }

    @Override
    protected void initEventAndData(final View view) {
        EventTracker.INSTANCE.log(EventType.HC_PAGE_HOME_OPENED);
        llNotification = get("aihelp_ll_notification");
        llRootLayout = get("aihelp_ll_root");
        prepareScreenOrientationAndDataSource();
    }

    private void prepareScreenOrientationAndDataSource() {
        if (llRootLayout != null) {
            llRootLayout.removeAllViews();
            if (Styles.isLandscape()) {
                View.inflate(getContext(), ResResolver.getLayoutId("aihelp_layout_faq_home_land"), llRootLayout);
            } else {
                View.inflate(getContext(), ResResolver.getLayoutId("aihelp_layout_faq_home_port"), llRootLayout);
            }
            rvHotTopics = llRootLayout.findViewById(ResResolver.getViewId("aihelp_rv_hot_topics"));
            rvCommonQuestions = llRootLayout.findViewById(ResResolver.getViewId("aihelp_rv_common_questions"));
        }
        if (getArguments() != null && isViewRestored()) {
            mPresenter.goFetchFAQDataSource(getArguments().getString(IntentValues.SECTION_ID));
        }
    }

    private void prepareFlipperView(List<FaqListEntity> notificationList) {
        if (CustomConfig.HelpCenter.isFaqNotificationVisible) {
            if (!ListUtil.isListEmpty(notificationList)) {
                if (llNotification != null) {
                    llNotification.setVisibility(View.VISIBLE);
                    if (CustomConfig.HelpCenter.isFaqNotificationIconVisible) {
                        ImageView ivNotification = get("aihelp_iv_notification");
                        ivNotification.setVisibility(View.VISIBLE);
                        Styles.loadIcon(ivNotification, CustomConfig.HelpCenter.faqNotificationIcon);
                    }
                    ViewFlipper vfNotification = get("aihelp_vf_notification");
                    for (int i = 0; i < notificationList.size(); i++) {
                        vfNotification.addView(getNotificationView(notificationList.get(i)));
                    }
                    vfNotification.startFlipping();
                    vfNotification.setFlipInterval(CustomConfig.HelpCenter.faqNotificationInterval * 1000);
                    vfNotification.setInAnimation(AnimationUtils.loadAnimation(getContext(), ResResolver.getAnimId("aihelp_push_up_in")));
                    vfNotification.setOutAnimation(AnimationUtils.loadAnimation(getContext(), ResResolver.getAnimId("aihelp_push_up_out")));
                    isNotificationEmpty = false;
                }
            }
        }
    }

    private void prepareHotTopics(List<FaqListEntity> hotTopics) {
        if (CustomConfig.HelpCenter.isFaqHotTopicVisible) {
            if (!ListUtil.isListEmpty(hotTopics)) {
                if (rvHotTopics != null) {
                    rvHotTopics.setVisibility(View.VISIBLE);
                    FaqCardLayoutAdapter hotTopicAdapter = new FaqCardLayoutAdapter(getContext());
                    hotTopicAdapter.setup(getMergedBundle(), getFaqFlowListener(), this);
                    hotTopicAdapter.setOnFaqSelectedListener(new FaqSelectedListenerWrapper() {

                        final Bundle bundle = getMergedBundle();

                        @Override
                        public void onIntentToQuestionContent(FaqListEntity faq) {
                            bundle.putString(IntentValues.SECTION_ID, FaqHelper.FAQ_HOT_TOPICS);
                            bundle.putString(IntentValues.FAQ_MAIN_ID, faq.getId());
                            getFaqFlowListener().onIntentToQuestionContent(bundle, true);
                        }

                    });
                    rvHotTopics.updateTitleIcon(CustomConfig.HelpCenter.isFaqHotTopicTitleVisible &&
                            CustomConfig.HelpCenter.isFaqHotTopicTitleIconVisible, CustomConfig.HelpCenter.faqHotTopicTitleIcon);
                    rvHotTopics.updateTitleText(CustomConfig.HelpCenter.isFaqHotTopicTitleVisible, CustomConfig.HelpCenter.faqHotTopicsTitle);
                    rvHotTopics.setup(hotTopicAdapter);
                    hotTopicAdapter.update(hotTopics);
                    isHotTopicsEmpty = false;
                }
            }
        }
    }

    private void prepareSectionList(List<FaqListEntity> sectionList) {
        if (!ListUtil.isListEmpty(sectionList)) {
            if (rvCommonQuestions != null) {
                rvCommonQuestions.setVisibility(View.VISIBLE);
                FaqCardLayoutAdapter commonQuestionAdapter = new FaqCardLayoutAdapter(getContext(), Styles.isLandscape());
                commonQuestionAdapter.setup(getMergedBundle(), getFaqFlowListener(), this);
                commonQuestionAdapter.setOnFaqSelectedListener(new FaqSelectedListenerWrapper() {

                    final Bundle bundle = getMergedBundle();

                    @Override
                    public void onIntentToSubSectionOrQuestionList(FaqListEntity faq) {
                        bundle.putString(IntentValues.SECTION_ID, faq.getId());
                        bundle.putString(IntentValues.SECTION_NAME, faq.getTitle());
                        bundle.putString(IntentValues.SECTION_ICON, faq.getIconUrl());
                        getFaqFlowListener().onIntentToQuestionList(bundle, true);
                        StatisticTracker.getInstance().clickSection(faq.getId(), faq.getSectionName());
                    }

                });
                rvCommonQuestions.updateTitleIcon(CustomConfig.HelpCenter.isFaqSectionTitleVisible &&
                        CustomConfig.HelpCenter.isFaqSectionTitleIconVisible, CustomConfig.HelpCenter.faqSectionTitleIcon);
                rvCommonQuestions.updateTitleText(CustomConfig.HelpCenter.isFaqSectionTitleVisible, CustomConfig.HelpCenter.faqSectionTitle);
                rvCommonQuestions.setup(CustomConfig.HelpCenter.isFaqSectionDisplayAsList, commonQuestionAdapter);
                commonQuestionAdapter.update(sectionList);
                isSectionsEmpty = false;
            }
        }
    }

    @Override
    protected int getLayout() {
        return ResResolver.getLayoutId("aihelp_fra_home_list");
    }

    @Override
    protected int getLoadingTargetViewId() {
        return ResResolver.getViewId("aihelp_main_content");
    }

    @Override
    protected boolean isBindEventBus() {
        return true;
    }

    @Override
    public void refreshList(List<FaqListEntity> displayFaqList, String section) {
        prepareFlipperView(FaqHelper.INSTANCE.getQuestionList(FaqHelper.FAQ_NOTIFICATION));
        prepareHotTopics(FaqHelper.INSTANCE.getQuestionList(FaqHelper.FAQ_HOT_TOPICS));
        prepareSectionList(displayFaqList);

        if (isNotificationEmpty && isHotTopicsEmpty && isSectionsEmpty) {
            showEmpty();
        } else {
            csEntrance = get("aihelp_cs_entrance");
            if (csEntrance != null) {
                csEntrance.setup(getMergedBundle(), getFaqFlowListener(), this);
            }
        }
        mPresenter.prepareFAQNotification();
    }

    private View getNotificationView(FaqListEntity faq) {
        TextView textView = new TextView(getContext());
        Styles.reRenderTextView(textView,
                faq.getTitle(),
                Color.parseColor(CustomConfig.CommonSetting.highlightedColor),
                true,
                14
        );
        textView.setSingleLine();
        textView.setEllipsize(TextUtils.TruncateAt.END);
        textView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                final Bundle bundle = getMergedBundle();
                bundle.putString(IntentValues.SECTION_ID, FaqHelper.FAQ_NOTIFICATION);
                bundle.putString(IntentValues.FAQ_MAIN_ID, faq.getId());
                getFaqFlowListener().onIntentToQuestionContent(bundle, true);
            }
        });
        return textView;
    }

    @Override
    public void showNetError() {
        super.showNetError();
        EventBus.getDefault().post(new NetErrorEvent());
    }

    @Override
    public void onEventComing(EventCenter event) {
        if (event instanceof OrientationChangeEvent) {
            prepareScreenOrientationAndDataSource();
            // 旋转屏幕后不会触发 onResume()，需要手动刷新一下才能显示客服入口
            csEntrance = get("aihelp_cs_entrance");
            if (csEntrance != null) {
                csEntrance.setup(getMergedBundle(), getFaqFlowListener(), this);
            }
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        EventTracker.INSTANCE.log(EventType.HC_PAGE_HOME_CLOSED);
    }
}
