package net.aihelp.ui.helper;

import android.content.Context;
import android.os.Bundle;
import android.text.Editable;

import net.aihelp.common.IntentValues;
import net.aihelp.config.enums.PushPlatform;
import net.aihelp.ui.cs.CustomerServiceFragment;
import net.aihelp.ui.cs.IntentUrlFragment;
import net.aihelp.ui.err.FaqErrorFragment;
import net.aihelp.ui.faq.FaqContentFragment;
import net.aihelp.ui.faq.FaqListFragment;
import net.aihelp.ui.faq.FaqSearchFragment;
import net.aihelp.ui.faq.FaqHomeFragment;
import net.aihelp.ui.wrapper.FaqEventListenerWrapper;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.TLog;

import java.util.concurrent.atomic.AtomicBoolean;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;

public class SupportHelper extends FaqEventListenerWrapper {

    private final Context context;
    private final FragmentManager childFragmentManager;
    private final Bundle bundle;
    private final AtomicBoolean isSupportStarted = new AtomicBoolean();

    private int supportMode;

    public SupportHelper(Context context, FragmentManager childFragmentManager, Bundle bundle) {
        this.context = context;
        this.childFragmentManager = childFragmentManager;
        this.bundle = bundle;
    }

    public void start() {
        if (!isSupportStarted.get()) {
            supportMode = bundle.getInt(IntentValues.SUPPORT_MODE, 0);
            switch (supportMode) {
                case IntentValues.MODE_CUSTOMER_SERVICE:
                    onIntentToCustomerService(bundle, false);
                    break;
                case IntentValues.MODE_SHOW_SECTION:
                    onIntentToQuestionList(bundle, false);
                    break;
                case IntentValues.MODE_SHOW_SINGLE_FAQ:
                    onIntentToQuestionContent(bundle, false);
                    break;
                case IntentValues.MODE_URL:
                    onIntentToFillForm(bundle, false);
                    break;
                case IntentValues.MODE_ERROR_ENTRANCE:
                    onIntentToErrorEntrance();
                    break;
                default:
                    onIntentToSectionRoot(bundle, false);
                    break;
            }
            isSupportStarted.set(true);
        }
    }

    private void onIntentToErrorEntrance() {
        FaqErrorFragment faqErrorFragment = FaqErrorFragment.newInstance(bundle);
        FragmentHelper.startFragment(childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"),
                faqErrorFragment, null, null, false, false);
    }

    public void onIntentToSectionRoot(Bundle bundle, boolean isAddToBackStack) {
        Fragment faqFragment;
        String backStackName = null;
        faqFragment = FaqHomeFragment.newInstance(bundle);
        if (isAddToBackStack) {
            backStackName = faqFragment.getClass().getName();
        }
        FragmentHelper.startFragment(childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"),
                faqFragment, null, backStackName, false, false);
    }

    @Override
    public void onIntentToQuestionList(Bundle bundle, boolean isAddToBackStack) {
        FaqListFragment fraQuestionList = FaqListFragment.newInstance(bundle);
        String backStackName = null;
        if (isAddToBackStack) {
            backStackName = fraQuestionList.getClass().getName();
        }
        FragmentHelper.startFragment(childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"),
                fraQuestionList, "", backStackName, false, false);
    }

    @Override
    public void onIntentToQuestionContent(Bundle bundle, boolean isAddToBackStack) {
        FaqContentFragment fraQuestionContent = FaqContentFragment.newInstance(bundle);
        String backStackName = null;
        if (isAddToBackStack) {
            backStackName = fraQuestionContent.getClass().getName();
        }
        FragmentHelper.startFragment(childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"),
                fraQuestionContent, "", backStackName, true, false);
    }

    @Override
    public void onIntentToSearch(Bundle bundle) {
        int fragmentContainerId;
        fragmentContainerId = ResResolver.getViewId("aihelp_support_fragment_container");
        FaqSearchFragment fraSearchFaq = FaqSearchFragment.newInstance(bundle);
        FragmentHelper.startFragment(childFragmentManager, fragmentContainerId,
                fraSearchFaq, "tag_faq_search", fraSearchFaq.getClass().getName(), false, false);
    }

    @Override
    public void onTextChanged(final CharSequence s, int start, int before, int count) {
        FaqSearchFragment searchFragment = (FaqSearchFragment) this.childFragmentManager.findFragmentByTag("tag_faq_search");
        if (searchFragment != null) {
            searchFragment.onQuery(String.valueOf(s).trim());
        }
    }

    @Override
    public void onIntentToCustomerService(Bundle bundle, boolean isAddToBackStack) {
        CustomerServiceFragment customerServiceFragment = CustomerServiceFragment.newInstance(bundle);
        String backStackName = null;
        if (isAddToBackStack) {
            backStackName = customerServiceFragment.getClass().getName();
        }
        FragmentHelper.startFragment(childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"),
                customerServiceFragment, null, backStackName, false, false);
    }


    @Override
    public void onIntentToFillForm(Bundle bundle, boolean isAddToBackStack) {
        IntentUrlFragment formFragment = IntentUrlFragment.newInstance(bundle);
        String backStackName = null;
        if (isAddToBackStack) {
            backStackName = formFragment.getClass().getName();
        }
        FragmentHelper.startFragment(childFragmentManager,
                ResResolver.getViewId("aihelp_support_fragment_container"), formFragment,
                backStackName, backStackName, false, false);
    }

    private Fragment getTopMostFaqFragment() {
        return FragmentHelper.getTopMostFragment(this.childFragmentManager);
    }

    @Override
    public void beforeTextChanged(CharSequence s, int start, int count, int after) {

    }

    @Override
    public void afterTextChanged(Editable s) {

    }

    //    @Override
//    public void onIntentToSectionList(Bundle bundle) {
//        FaqHomeFragment fraSectionList = FaqHomeFragment.newInstance(bundle);
//        boolean shouldShowRootSection = bundle.getString(IntentValues.SECTION_ID) == null;
//        if (shouldShowRootSection) {
//            FragmentHelper.startFragment(childFragmentManager, ResResolver.getViewId("aihelp_faq_root"),
//                    fraSectionList, null, null,
//                    false, false);
//        } else {
//            FragmentHelper.startFragment(childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"),
//                    fraSectionList, null, bundle.getString(IntentValues.SECTION_ID),
//                    false, false);
//        }
//    }

//    public void onIntentToElvaBot(Bundle bundle) {
//        PreviewFragment formFragment = PreviewFragment.newInstance(bundle);
//        String backStackName = formFragment.getClass().getName();
//        FragmentHelper.startFragment(childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"), formFragment,
//                backStackName, backStackName, false, true);
//    }
//
//    public void onIntentToConversation(Bundle bundle){
//        startConversation(bundle, true);
//    }

//    private void onIntentToOperate(Bundle bundle) {
//        OperationFragment operateFragment = OperationFragment.newInstance(bundle);
//        FragmentHelper.startFragment(childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"),
//                operateFragment, null, null,
//                false, false);
//    }
//
//    @Override
//    public void onIntentToOperateContent(Bundle bundle) {
//        OperateContentFragment fraOperateContent = OperateContentFragment.newInstance(bundle);
//        FragmentHelper.startFragment(childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"),
//                fraOperateContent, "fraOperateContent", fraOperateContent.getClass().getName(),
//                true, false);
//    }

    //    public void startElva(Bundle bundle, boolean isAddToBackStack) {
//        if (MqttConfig.getInstance().isConnected()) return;
//        Fragment elvaBot = ElvaBotFragment.newInstance(bundle);
//        String backStackName = null;
//        if (isAddToBackStack) {
//            backStackName = elvaBot.getClass().getName();
//        }
//        FragmentHelper.startFragment(childFragmentManager,
//                ResResolver.getViewId("aihelp_support_fragment_container"), elvaBot,
//                backStackName, backStackName, false, false);
//    }
//
//    public void startConversation(Bundle bundle, boolean isAddToBackStack) {
//        Fragment conversationFragment = ConversationFragment.newInstance(bundle);
//        String backStackName = null;
//        if (isAddToBackStack) {
//            backStackName = conversationFragment.getClass().getName();
//        }
//        FragmentHelper.startFragment(childFragmentManager, ResResolver.getViewId("aihelp_support_fragment_container"), conversationFragment,
//                backStackName, backStackName, false, false);
//    }

}
