package net.aihelp.ui.helper;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;

import net.aihelp.common.CustomConfig;
import net.aihelp.ui.preview.PreviewActivity;
import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.ui.webkit.AIHelpWebViewClient;

import androidx.fragment.app.Fragment;

public class WebViewInjector {

    private Context context;
    private Fragment fragment;

    public static WebViewInjector getInstance() {
        return new WebViewInjector();
    }

    public WebViewInjector setHostFragment(Fragment fragment) {
        this.fragment = fragment;
        return this;
    }

    public WebViewInjector setContext(Context context) {
        this.context = context;
        return this;
    }

    @SuppressLint("AddJavascriptInterface")
    public void inject(WebView webView, AIHelpWebViewClient webViewClient) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            webView.addJavascriptInterface(this, "AIHelp");
            webViewClient.setOnPageLoadingProgressListener(new AIHelpWebViewClient.OnPageLoadingProgressListener() {
                @Override
                public void onPageStarted(WebView view, String url) {
                }

                @Override
                public void onPageFinished(WebView view, String url) {
                    String js = "setTimeout(function() {\n" +
                            "  var script = document.createElement('script');\n" +
                            "  script.innerHTML = `var imgList = document.getElementsByTagName('img');\n" +
                            "  for (const img of imgList) {\n" +
                            "    img.onclick = function() {\n" +
                            "      window.AIHelp.showImage(img.src)\n" +
                            "    }\n" +
                            "}`;\n" +
                            "  document.head.appendChild(script);\n" +
                            "}, 500);";
                    view.evaluateJavascript(js, null);
                }
            });
        }
    }

    @JavascriptInterface
    public void showImage(String imgUrl) {
        if (fragment != null) {
            PreviewActivity.startAct(fragment, PreviewInfo.get(imgUrl));
        } else if (context != null) {
            PreviewActivity.startAct(context, PreviewInfo.get(imgUrl));
        }
    }

}
