package net.aihelp.ui.preview.util;

import android.app.Activity;
import android.graphics.Color;
import android.os.Build;
import android.view.View;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import net.aihelp.ui.preview.data.PreviewInfo;
import net.aihelp.ui.widget.AIHelpButton;
import net.aihelp.ui.widget.CircleProgressView;
import net.aihelp.utils.AppInfoUtil;
import net.aihelp.utils.DownloadHelper;
import net.aihelp.utils.RegexUtil;
import net.aihelp.utils.ResResolver;
import net.aihelp.utils.Styles;
import net.aihelp.utils.ToastUtil;

public class PreviewHelper {

    public static boolean prepare(Activity activity, PreviewInfo info) {
        if (activity == null) return false;
        if (info == null) {
            activity.setResult(Activity.RESULT_CANCELED, activity.getIntent());
            activity.finish();
            return false;
        }
        prepareThemeApply(activity, info);
        prepareButtonUI(activity, info);
        prepareDownloadUI(activity, info);
        prepareOpenInBrowserUI(activity, info);
        return true;
    }

    private static void prepareThemeApply(Activity activity, PreviewInfo info) {
        boolean darkTheme = info.isMediaFile() || Styles.isNightMode(activity);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            activity.getWindow().clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
            activity.getWindow().addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
            activity.getWindow().setStatusBarColor(darkTheme ? Color.BLACK : Color.WHITE);
            if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
                activity.getWindow().getDecorView().setSystemUiVisibility(darkTheme ? View.SYSTEM_UI_FLAG_VISIBLE :
                        View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR);
            }
        }
        RelativeLayout rlPreviewTitle = activity.findViewById(ResResolver.getViewId("aihelp_rl_preview_title"));
        rlPreviewTitle.setBackgroundColor(darkTheme ? Color.BLACK : Color.WHITE);
        RelativeLayout rlPreviewContent = activity.findViewById(ResResolver.getViewId("aihelp_rl_preview_content"));
        rlPreviewContent.setBackgroundColor(darkTheme ? Color.BLACK : Color.WHITE);
    }

    private static void prepareButtonUI(Activity activity, PreviewInfo info) {
        ImageView ivBack = activity.findViewById(ResResolver.getViewId("aihelp_iv_back"));
        Styles.reRenderImageView(ivBack, "aihelp_svg_ic_back", true);
        ivBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                activity.setResult(Activity.RESULT_CANCELED, activity.getIntent());
                activity.finish();
            }
        });

        AIHelpButton btnConfirm = activity.findViewById(ResResolver.getViewId("aihelp_btn_confirm"));
        btnConfirm.setVisibility(info.isPicking() ? View.VISIBLE : View.GONE);
        btnConfirm.setText(ResResolver.getString("aihelp_yes"));
        btnConfirm.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                activity.setResult(Activity.RESULT_OK, activity.getIntent());
                activity.finish();
            }
        });
    }

    private static void prepareDownloadUI(Activity activity, PreviewInfo info) {
        CircleProgressView progressView = activity.findViewById(ResResolver.getViewId("aihelp_progress_view"));
        ImageView ivDownload = activity.findViewById(ResResolver.getViewId("aihelp_iv_download"));
        boolean hideIcon = RegexUtil.isLocalMediaFile(info.getFilePath()) || info.isPicking() || !info.isMediaFile();
        ivDownload.setVisibility(hideIcon ? View.GONE : View.VISIBLE);
        ivDownload.setBackground(Styles.getDrawable(Color.parseColor("#3F3F3F"), 999));
        Styles.reRenderImageView(ivDownload, "aihelp_svg_ic_download", Color.WHITE, true);
        ivDownload.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (AppInfoUtil.validateNetwork(activity)) {
                    ivDownload.setEnabled(false);
                    DownloadHelper.save(activity, info.getFilePath(), new DownloadHelper.OnDownloadProgressChangedListener() {
                        @Override
                        public void onProgressChanged(int progress) {
                            ivDownload.setEnabled(progress == 100);
                            if (info.isVideoFile()) {
                                if (progress < 100) {
                                    progressView.setVisibility(View.VISIBLE);
                                    progressView.setCurrentStep(progress);
                                } else {
                                    progressView.setVisibility(View.GONE);
                                    ToastUtil.INSTANCE.makeTextWithIcon(activity, ResResolver.getString("aihelp_save_seccessfully"), false);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    private static void prepareOpenInBrowserUI(Activity activity, PreviewInfo info) {
        AIHelpButton btnOpen = activity.findViewById(ResResolver.getViewId("aihelp_btn_open"));
        btnOpen.setText(ResResolver.getString("aihelp_open_browser"));
        boolean hideIcon = RegexUtil.isLocalFile(info.getFilePath()) || info.isPicking();
        btnOpen.setVisibility(hideIcon ? View.GONE : View.VISIBLE);
        btnOpen.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                AppInfoUtil.openWithBrowser(activity, info.getFilePath());
            }
        });
    }

}
