package net.aihelp.ui.webkit;

import android.Manifest;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ClipData;
import android.content.Intent;
import android.graphics.Color;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebView;

import net.aihelp.config.AIHelpContext;
import net.aihelp.core.util.bus.EventBus;
import net.aihelp.core.util.permission.AIHelpPermissions;
import net.aihelp.core.util.permission.Permission;
import net.aihelp.data.event.UpdateTitleEvent;
import net.aihelp.ui.cs.IntentUrlFragment;
import net.aihelp.data.attachment.AttachmentHelper;
import net.aihelp.data.attachment.AttachmentPicker;
import net.aihelp.utils.TLog;

import java.io.File;

import androidx.fragment.app.Fragment;

public class AIHelpWebChromeClient extends WebChromeClient {

    private final Fragment fragment;
    private final AIHelpWebProgress webProgress;
    private Window window;
    private ViewGroup fullScreenContainer;

    private ValueCallback<Uri> mUploadMessage;// 表单的数据信息
    private ValueCallback<Uri[]> mUploadCallbackAboveL;
    public final static int REQUEST_CODE = 1;// 表单的结果回调

    private View mCustomView = null;

    public AIHelpWebChromeClient(Fragment fragment, AIHelpWebProgress webProgress) {
        this.fragment = fragment;
        this.webProgress = webProgress;
        if (fragment != null && fragment.getActivity() != null) {
            window = fragment.getActivity().getWindow();
            this.fullScreenContainer = window.getDecorView().findViewById(android.R.id.content);
        }
    }

    @Override
    public void onShowCustomView(View view, CustomViewCallback callback) {
        super.onShowCustomView(view, callback);
        if (view != null && fullScreenContainer != null) {
            mCustomView = view;
            mCustomView.setBackgroundColor(Color.parseColor("#000000"));
            fullScreenContainer.addView(mCustomView);
            window.setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN,
                    WindowManager.LayoutParams.FLAG_FULLSCREEN);
        }
    }

    @Override
    public void onHideCustomView() {
        super.onHideCustomView();
        if (mCustomView != null && fullScreenContainer != null) {

            fullScreenContainer.removeView(mCustomView);
            mCustomView = null;

            final WindowManager.LayoutParams attrs = window.getAttributes();
            attrs.flags &= (~WindowManager.LayoutParams.FLAG_FULLSCREEN);
            window.setAttributes(attrs);
            window.clearFlags(WindowManager.LayoutParams.FLAG_LAYOUT_NO_LIMITS);
        }
    }

    @Override
    public void onReceivedTitle(WebView view, String title) {
        super.onReceivedTitle(view, title);
        if (!TextUtils.isEmpty(title) && !"AIHelp".equals(title) && !"about:blank".equals(title)) {
            if (fragment instanceof IntentUrlFragment) {
                EventBus.getDefault().post(new UpdateTitleEvent(title));
            }
        }
    }

    @Override
    public void onProgressChanged(WebView view, int newProgress) {
        super.onProgressChanged(view, newProgress);
        webProgress.setProgress(newProgress);
    }

    // > android 5.0
    public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, FileChooserParams fileChooserParams) {
        mUploadCallbackAboveL = filePathCallback;
        tryGetFileFromData();
        return true;
    }

    // < android 3.0
    public void openFileChooser(ValueCallback<Uri> uploadMsg) {
        mUploadMessage = uploadMsg;
        tryGetFileFromData();
    }

    // >= android 3.0 & < android 4.0
    public void openFileChooser(ValueCallback<Uri> uploadMsg, String acceptType) {
        mUploadMessage = uploadMsg;
        tryGetFileFromData();
    }

    // >= android 4.0 & < android 4.3 & android 4.4.4
    public void openFileChooser(ValueCallback<Uri> uploadMsg, String acceptType, String capture) {
        mUploadMessage = uploadMsg;
        tryGetFileFromData();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        try {
            if (requestCode == REQUEST_CODE) {
                if (null == mUploadMessage && null == mUploadCallbackAboveL) return;
                Uri result = data == null || resultCode != Activity.RESULT_OK ? null : data.getData();
                if (mUploadCallbackAboveL != null) {
                    Uri[] results = null;
                    File copiedUriFile = AttachmentHelper.getCopiedUriFile(AIHelpContext.getInstance().getContext(), result);
                    if (copiedUriFile != null) {
                        results = new Uri[]{Uri.fromFile(copiedUriFile)};
                    }
                    mUploadCallbackAboveL.onReceiveValue(results);
                    mUploadCallbackAboveL = null;
                } else if (mUploadMessage != null) {
                    if (result != null) {
                        File copiedUriFile = AttachmentHelper.getCopiedUriFile(AIHelpContext.getInstance().getContext(), result);
                        Uri uri = null;
                        if (copiedUriFile != null) {
                            uri = Uri.fromFile(copiedUriFile);
                        }
                        mUploadMessage.onReceiveValue(uri);
                    } else {
                        mUploadMessage.onReceiveValue(null);
                    }
                    mUploadMessage = null;
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cancelChooseFileDialog() {
        if (null != mUploadCallbackAboveL) {
            mUploadCallbackAboveL.onReceiveValue(null);
            mUploadCallbackAboveL = null;
        }
        if (null != mUploadMessage) {
            mUploadMessage.onReceiveValue(null);
            mUploadMessage = null;
        }
    }


    @SuppressWarnings("null")
    @TargetApi(Build.VERSION_CODES.BASE)
    private void onActivityResultAboveL(int requestCode, int resultCode, Intent data) {
        if (requestCode != REQUEST_CODE
                || mUploadCallbackAboveL == null) {
            return;
        }
        Uri[] results = null;
        if (resultCode == Activity.RESULT_OK) {
            if (data != null) {
                String dataString = data.getDataString();
                ClipData clipData = null;
                if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.JELLY_BEAN) {
                    clipData = data.getClipData();
                }
                if (clipData != null) {
                    results = new Uri[clipData.getItemCount()];
                    for (int i = 0; i < clipData.getItemCount(); i++) {
                        ClipData.Item item = clipData.getItemAt(i);
                        results[i] = item.getUri();
                    }
                }
                if (dataString != null)
                    results = new Uri[]{Uri.parse(dataString)};
            }
        }
        if (results != null) {
            mUploadCallbackAboveL.onReceiveValue(results);
            mUploadCallbackAboveL = null;
        } else {
            mUploadCallbackAboveL.onReceiveValue(null);
            mUploadCallbackAboveL = null;
        }
    }

    private void tryGetFileFromData() {
        String[] permissionArray = new String[]{Manifest.permission.READ_EXTERNAL_STORAGE};
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.TIRAMISU) {
            permissionArray = new String[]{
                    Manifest.permission.READ_MEDIA_IMAGES,
                    Manifest.permission.READ_MEDIA_VIDEO
            };
        }
        AIHelpPermissions.getInstance()
                .setPermissionHandler(fragment)
                .setRequestCode(Permission.REQUEST_CODE_FORM)
                .setRequestPermission(permissionArray)
                .request(fragment.getContext(), AttachmentPicker.ATTACHMENT_TYPE_MEDIA);

    }

}
